/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.HashSet;

public class TypesDistinctProver {
    private TypesDistinctProver() {
    }

    public static boolean provablyDistinct(PsiType type1, PsiType type2) {
        return TypesDistinctProver.provablyDistinct(type1, type2, 0);
    }

    private static boolean provablyDistinct(PsiType type1, PsiType type2, int level) {
        if (type1 instanceof PsiClassType && ((PsiClassType)type1).resolve() instanceof PsiTypeParameter) {
            return false;
        }
        if (type2 instanceof PsiClassType && ((PsiClassType)type2).resolve() instanceof PsiTypeParameter) {
            return false;
        }
        if (type1 instanceof PsiWildcardType) {
            if (type2 instanceof PsiWildcardType) {
                return TypesDistinctProver.provablyDistinct((PsiWildcardType)type1, (PsiWildcardType)type2);
            }
            if (type2 instanceof PsiCapturedWildcardType) {
                return ((PsiWildcardType)type1).isExtends() && level > 0 || TypesDistinctProver.provablyDistinct((PsiWildcardType)type1, ((PsiCapturedWildcardType)type2).getWildcard());
            }
            if (type2 instanceof PsiClassType) {
                PsiClass psiClass2 = PsiUtil.resolveClassInType(type2);
                if (psiClass2 == null) {
                    return false;
                }
                if (((PsiWildcardType)type1).isExtends()) {
                    PsiType extendsBound = ((PsiWildcardType)type1).getExtendsBound();
                    if (extendsBound instanceof PsiArrayType && TypesDistinctProver.proveArrayTypeDistinct(((PsiWildcardType)type1).getManager().getProject(), (PsiArrayType)extendsBound, type2)) {
                        return true;
                    }
                    PsiClass boundClass1 = PsiUtil.resolveClassInType(extendsBound);
                    if (boundClass1 == null) {
                        return false;
                    }
                    if ("java.lang.Object".equals(psiClass2.getQualifiedName())) {
                        return !"java.lang.Object".equals(boundClass1.getQualifiedName());
                    }
                    return TypesDistinctProver.proveExtendsBoundsDistinct(type1, type2, boundClass1, psiClass2);
                }
                if (((PsiWildcardType)type1).isSuper()) {
                    PsiType superBound = ((PsiWildcardType)type1).getSuperBound();
                    if (superBound instanceof PsiArrayType && TypesDistinctProver.proveArrayTypeDistinct(((PsiWildcardType)type1).getManager().getProject(), (PsiArrayType)superBound, type2)) {
                        return true;
                    }
                    PsiClass boundClass1 = PsiUtil.resolveClassInType(superBound);
                    if (boundClass1 == null || boundClass1 instanceof PsiTypeParameter) {
                        return false;
                    }
                    return !InheritanceUtil.isInheritorOrSelf(boundClass1, psiClass2, true);
                }
                PsiType bound = ((PsiWildcardType)type1).getBound();
                return bound != null && !bound.equals(psiClass2);
            }
            if (type2 instanceof PsiArrayType) {
                return TypesDistinctProver.proveArrayTypeDistinct(((PsiWildcardType)type1).getManager().getProject(), (PsiArrayType)type2, type1);
            }
        }
        if (type1 instanceof PsiCapturedWildcardType) {
            return TypesDistinctProver.provablyDistinct(((PsiCapturedWildcardType)type1).getWildcard(), type2, level);
        }
        if (type2 instanceof PsiWildcardType || type2 instanceof PsiCapturedWildcardType) {
            return TypesDistinctProver.provablyDistinct(type2, type1, level);
        }
        PsiClassType.ClassResolveResult classResolveResult1 = PsiUtil.resolveGenericsClassInType(type1);
        PsiClassType.ClassResolveResult classResolveResult2 = PsiUtil.resolveGenericsClassInType(type2);
        if (Comparing.equal(TypeConversionUtil.erasure(type1), TypeConversionUtil.erasure(type2))) {
            PsiSubstitutor substitutor1 = classResolveResult1.getSubstitutor();
            PsiSubstitutor substitutor2 = classResolveResult2.getSubstitutor();
            for (PsiTypeParameter parameter : substitutor1.getSubstitutionMap().keySet()) {
                PsiType substitutedType1 = substitutor1.substitute(parameter);
                PsiType substitutedType2 = substitutor2.substitute(parameter);
                if (substitutedType1 == null && substitutedType2 == null) {
                    return false;
                }
                if (substitutedType1 == null || substitutedType2 == null) {
                    return true;
                }
                if (TypesDistinctProver.provablyDistinct(substitutedType1, substitutedType2, level + 1)) {
                    return true;
                }
                if (!(substitutedType1 instanceof PsiWildcardType) || ((PsiWildcardType)substitutedType1).isBounded()) continue;
                return true;
            }
            return false;
        }
        PsiClass boundClass1 = classResolveResult1.getElement();
        PsiClass boundClass2 = classResolveResult2.getElement();
        return type2 != null && type1 != null && !type1.equals(type2) && (!InheritanceUtil.isInheritorOrSelf(boundClass1, boundClass2, true) || !InheritanceUtil.isInheritorOrSelf(boundClass2, boundClass1, true));
    }

    public static boolean provablyDistinct(PsiWildcardType type1, PsiWildcardType type2) {
        if (type1.isSuper() && type2.isSuper()) {
            return false;
        }
        if (type1.isExtends() && type2.isExtends()) {
            PsiType extendsBound1 = type1.getExtendsBound();
            PsiType extendsBound2 = type2.getExtendsBound();
            if (extendsBound1 instanceof PsiArrayType && TypesDistinctProver.proveArrayTypeDistinct(type1.getManager().getProject(), (PsiArrayType)extendsBound1, extendsBound2) || extendsBound2 instanceof PsiArrayType && TypesDistinctProver.proveArrayTypeDistinct(type1.getManager().getProject(), (PsiArrayType)extendsBound2, extendsBound1)) {
                return true;
            }
            PsiClass boundClass1 = PsiUtil.resolveClassInType(extendsBound1);
            PsiClass boundClass2 = PsiUtil.resolveClassInType(extendsBound2);
            if (boundClass1 != null && boundClass2 != null) {
                return TypesDistinctProver.proveExtendsBoundsDistinct(type1, type2, boundClass1, boundClass2);
            }
            return TypesDistinctProver.provablyDistinct(extendsBound1, extendsBound2, 1);
        }
        if (type2.isExtends()) {
            return TypesDistinctProver.provablyDistinct(type2, type1);
        }
        if (type1.isExtends() && type2.isSuper()) {
            PsiType extendsBound = type1.getExtendsBound();
            PsiType superBound = type2.getSuperBound();
            if (extendsBound instanceof PsiArrayType && TypesDistinctProver.proveArrayTypeDistinct(type1.getManager().getProject(), (PsiArrayType)extendsBound, superBound) || superBound instanceof PsiArrayType && TypesDistinctProver.proveArrayTypeDistinct(type1.getManager().getProject(), (PsiArrayType)superBound, extendsBound)) {
                return true;
            }
            PsiClass extendsBoundClass = PsiUtil.resolveClassInType(extendsBound);
            PsiClass superBoundClass = PsiUtil.resolveClassInType(superBound);
            if (extendsBoundClass != null && superBoundClass != null) {
                if (extendsBoundClass instanceof PsiTypeParameter) {
                    return TypesDistinctProver.try2ProveTypeParameterDistinct(type2, extendsBoundClass);
                }
                if (superBoundClass instanceof PsiTypeParameter) {
                    return false;
                }
                return !InheritanceUtil.isInheritorOrSelf(superBoundClass, extendsBoundClass, true);
            }
            return true;
        }
        if (!type1.isBounded() || !type2.isBounded()) {
            return false;
        }
        return !type1.equals(type2);
    }

    public static boolean proveExtendsBoundsDistinct(PsiType type1, PsiType type2, PsiClass boundClass1, PsiClass boundClass2) {
        if (boundClass1 == null || boundClass2 == null) {
            return false;
        }
        if (boundClass1.isInterface() && boundClass2.isInterface()) {
            return false;
        }
        if (boundClass1.isInterface()) {
            return boundClass2.hasModifierProperty("final") && !InheritanceUtil.isInheritorOrSelf(boundClass2, boundClass1, true);
        }
        if (boundClass2.isInterface()) {
            return boundClass1.hasModifierProperty("final") && !InheritanceUtil.isInheritorOrSelf(boundClass1, boundClass2, true);
        }
        if (boundClass1 instanceof PsiTypeParameter) {
            return TypesDistinctProver.try2ProveTypeParameterDistinct(type2, boundClass1);
        }
        if (boundClass2 instanceof PsiTypeParameter) {
            return TypesDistinctProver.try2ProveTypeParameterDistinct(type1, boundClass2);
        }
        return !InheritanceUtil.isInheritorOrSelf(boundClass1, boundClass2, true) && !InheritanceUtil.isInheritorOrSelf(boundClass2, boundClass1, true);
    }

    public static boolean try2ProveTypeParameterDistinct(PsiType type, PsiClass typeParameter) {
        PsiClassType[] types = typeParameter.getExtendsListTypes();
        if (types.length == 0) {
            return false;
        }
        return TypesDistinctProver.provablyDistinct((PsiType)PsiWildcardType.createExtends(typeParameter.getManager(), types[0]), type);
    }

    public static boolean proveArrayTypeDistinct(Project project, PsiArrayType type, PsiType bound) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
        GlobalSearchScope searchScope = GlobalSearchScope.allScope(project);
        HashSet<PsiClass> possibleClasses = new HashSet<PsiClass>();
        possibleClasses.add(facade.findClass("java.io.Serializable", searchScope));
        possibleClasses.add(facade.findClass("java.lang.Cloneable", searchScope));
        possibleClasses.add(facade.findClass("java.lang.Object", searchScope));
        if (type.getArrayDimensions() == bound.getArrayDimensions()) {
            PsiType componentType = type.getComponentType();
            PsiType boundComponentType = ((PsiArrayType)bound).getComponentType();
            if (boundComponentType instanceof PsiClassType && componentType instanceof PsiClassType) {
                return TypesDistinctProver.proveExtendsBoundsDistinct(boundComponentType, componentType, ((PsiClassType)boundComponentType).resolve(), ((PsiClassType)componentType).resolve());
            }
            return !bound.equals(type);
        }
        if (bound.getArrayDimensions() + 1 == type.getArrayDimensions() && bound.getDeepComponentType() instanceof PsiClassType) {
            return !possibleClasses.contains(((PsiClassType)bound.getDeepComponentType()).resolve());
        }
        if (bound.getArrayDimensions() == type.getArrayDimensions() + 1 && type.getDeepComponentType() instanceof PsiClassType) {
            return !possibleClasses.contains(((PsiClassType)type.getDeepComponentType()).resolve());
        }
        if (bound instanceof PsiClassType) {
            return !possibleClasses.contains(((PsiClassType)bound).resolve());
        }
        if (bound instanceof PsiWildcardType) {
            PsiType boundBound = ((PsiWildcardType)bound).getBound();
            return boundBound != null && !boundBound.equals(type);
        }
        return true;
    }
}

