/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.jetbrains.annotations.NotNull;

public class ReflectionCache {
    private static final ConcurrentFactoryMap<Class, Class> ourSuperClasses = new ConcurrentFactoryMap<Class, Class>(){

        @Override
        protected Class create(Class key) {
            return key.getSuperclass();
        }
    };
    private static final ConcurrentFactoryMap<Class, Class[]> ourInterfaces = new ConcurrentFactoryMap<Class, Class[]>(){

        @Override
        @NotNull
        protected Class[] create(Class key) {
            Class<?>[] classes = key.getInterfaces();
            Class[] classArray = classes.length == 0 ? ArrayUtil.EMPTY_CLASS_ARRAY : classes;
            if (classArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionCache$2.create must not return null");
            }
            return classArray;
        }
    };
    private static final ConcurrentFactoryMap<Class, Boolean> ourIsInterfaces = new ConcurrentFactoryMap<Class, Boolean>(){

        @Override
        @NotNull
        protected Boolean create(Class key) {
            Boolean bl = key.isInterface();
            if (bl == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionCache$3.create must not return null");
            }
            return bl;
        }
    };
    private static final ConcurrentFactoryMap<Class, TypeVariable[]> ourTypeParameters = new ConcurrentFactoryMap<Class, TypeVariable[]>(){

        @Override
        @NotNull
        protected TypeVariable[] create(Class key) {
            TypeVariable[] typeVariableArray = key.getTypeParameters();
            if (typeVariableArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionCache$4.create must not return null");
            }
            return typeVariableArray;
        }
    };
    private static final ConcurrentFactoryMap<Class, Type[]> ourGenericInterfaces = new ConcurrentFactoryMap<Class, Type[]>(){

        @Override
        @NotNull
        protected Type[] create(Class key) {
            Type[] typeArray = key.getGenericInterfaces();
            if (typeArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionCache$5.create must not return null");
            }
            return typeArray;
        }
    };
    private static final ConcurrentFactoryMap<ParameterizedType, Type[]> ourActualTypeArguments = new ConcurrentFactoryMap<ParameterizedType, Type[]>(){

        @Override
        @NotNull
        protected Type[] create(ParameterizedType key) {
            Type[] typeArray = key.getActualTypeArguments();
            if (typeArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionCache$6.create must not return null");
            }
            return typeArray;
        }
    };

    public static Class getSuperClass(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ReflectionCache.getSuperClass must not be null");
        }
        return (Class)ourSuperClasses.get(aClass);
    }

    @NotNull
    public static Class[] getInterfaces(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ReflectionCache.getInterfaces must not be null");
        }
        Class[] classArray = (Class[])ourInterfaces.get(aClass);
        if (classArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionCache.getInterfaces must not return null");
        }
        return classArray;
    }

    public static boolean isAssignable(@NotNull Class ancestor, Class descendant) {
        if (ancestor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ReflectionCache.isAssignable must not be null");
        }
        return ancestor == descendant || ancestor.isAssignableFrom(descendant);
    }

    public static boolean isInstance(Object instance, @NotNull Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ReflectionCache.isInstance must not be null");
        }
        return clazz.isInstance(instance);
    }
}

