/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class UniqueResultsQuery<T, M>
implements Query<T> {
    private final Query<T> myOriginal;
    private final TObjectHashingStrategy<M> myHashingStrategy;
    private final Function<T, M> myMapper;

    public UniqueResultsQuery(@NotNull Query<T> original) {
        if (original == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/UniqueResultsQuery.<init> must not be null");
        }
        this(original, ContainerUtil.canonicalStrategy(), FunctionUtil.id());
    }

    public UniqueResultsQuery(@NotNull Query<T> original, @NotNull TObjectHashingStrategy<M> hashingStrategy) {
        if (original == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/UniqueResultsQuery.<init> must not be null");
        }
        if (hashingStrategy == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/UniqueResultsQuery.<init> must not be null");
        }
        this(original, hashingStrategy, FunctionUtil.id());
    }

    public UniqueResultsQuery(@NotNull Query<T> original, @NotNull TObjectHashingStrategy<M> hashingStrategy, @NotNull Function<T, M> mapper) {
        if (original == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/UniqueResultsQuery.<init> must not be null");
        }
        if (hashingStrategy == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/UniqueResultsQuery.<init> must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/UniqueResultsQuery.<init> must not be null");
        }
        this.myOriginal = original;
        this.myHashingStrategy = hashingStrategy;
        this.myMapper = mapper;
    }

    @Override
    public T findFirst() {
        return this.myOriginal.findFirst();
    }

    @Override
    public boolean forEach(@NotNull Processor<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/UniqueResultsQuery.forEach must not be null");
        }
        return this.process(consumer, Collections.synchronizedSet(new THashSet<M>(this.myHashingStrategy)));
    }

    private boolean process(Processor<T> consumer, Set<M> processedElements) {
        return this.myOriginal.forEach(new MyProcessor(processedElements, consumer));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Collection<T> findAll() {
        Collection<Object> collection;
        if (this.myMapper == Function.ID) {
            THashSet<M> set = new THashSet<M>(this.myHashingStrategy);
            this.process(CommonProcessors.alwaysTrue(), Collections.synchronizedSet(set));
            collection = set;
            if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/util/UniqueResultsQuery.findAll must not return null");
            return collection;
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor(Collections.synchronizedList(new ArrayList()));
        this.forEach((Processor<T>)processor);
        collection = processor.getResults();
        if (collection != null) return collection;
        throw new IllegalStateException("@NotNull method com/intellij/util/UniqueResultsQuery.findAll must not return null");
    }

    @Override
    public Iterator<T> iterator() {
        return this.findAll().iterator();
    }

    private class MyProcessor
    implements Processor<T> {
        private final Set<M> myProcessedElements;
        private final Processor<T> myConsumer;

        public MyProcessor(Set<M> processedElements, Processor<T> consumer) {
            this.myProcessedElements = processedElements;
            this.myConsumer = consumer;
        }

        @Override
        public boolean process(T t) {
            return !this.myProcessedElements.add(UniqueResultsQuery.this.myMapper.fun(t)) || this.myConsumer.process(t);
        }
    }
}

