/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class Semaphore {
    private final Sync sync;

    public void up() {
        this.tryUp();
    }

    public boolean tryUp() {
        return this.sync.releaseShared(1);
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        @Override
        public int tryAcquireShared(int acquires) {
            return this.getState() == 0 ? 1 : -1;
        }

        @Override
        public boolean tryReleaseShared(int releases) {
            int nextc;
            int c;
            do {
                if ((c = this.getState()) != 0) continue;
                return false;
            } while (!this.compareAndSetState(c, nextc = c - 1));
            return nextc == 0;
        }
    }
}

