/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.StripedLockIntObjectConcurrentHashMap;
import java.lang.ref.ReferenceQueue;
import org.jetbrains.annotations.NotNull;

abstract class ConcurrentRefValueIntObjectHashMap<V> {
    private final StripedLockIntObjectConcurrentHashMap<IntReference<V>> myMap = new StripedLockIntObjectConcurrentHashMap();
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    ConcurrentRefValueIntObjectHashMap() {
    }

    protected abstract IntReference<V> createReference(int var1, @NotNull V var2, ReferenceQueue<V> var3);

    private void processQueue() {
        IntReference ref;
        while ((ref = (IntReference)((Object)this.myQueue.poll())) != null) {
            int key = ref.getKey();
            this.myMap.remove(key, ref);
        }
        return;
    }

    public V put(int key, @NotNull V value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap.put must not be null");
        }
        this.processQueue();
        IntReference<V> ref = this.myMap.put(key, this.createReference(key, value, this.myQueue));
        return ref == null ? null : (V)ref.get();
    }

    public V get(int key) {
        IntReference<V> ref = this.myMap.get(key);
        return ref == null ? null : (V)ref.get();
    }

    protected static interface IntReference<V> {
        public int getKey();

        public V get();
    }
}

