/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.Stack;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerUtilRt {
    @NotNull
    public static <K, V> java.util.HashMap<K, V> newHashMap() {
        HashMap hashMap = new HashMap();
        if (hashMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtilRt.newHashMap must not return null");
        }
        return hashMap;
    }

    @NotNull
    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {
        TreeMap treeMap = new TreeMap();
        if (treeMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtilRt.newTreeMap must not return null");
        }
        return treeMap;
    }

    @NotNull
    public static <T> ArrayList<T> newArrayList() {
        ArrayList arrayList = new ArrayList();
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtilRt.newArrayList must not return null");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> ArrayList<T> newArrayList(@NotNull Iterable<? extends T> elements) {
        ArrayList<Object> arrayList;
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtilRt.newArrayList must not be null");
        }
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            arrayList = new ArrayList(collection);
            if (arrayList == null) throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtilRt.newArrayList must not return null");
            return arrayList;
        }
        arrayList = ContainerUtilRt.copy(ContainerUtilRt.<T>newArrayList(), elements);
        if (arrayList != null) return arrayList;
        throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtilRt.newArrayList must not return null");
    }

    @NotNull
    public static <T> ArrayList<T> newArrayListWithExpectedSize(int size) {
        ArrayList arrayList = new ArrayList(size);
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtilRt.newArrayListWithExpectedSize must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static <T> ArrayList<T> newArrayListWithCapacity(int size) {
        ArrayList arrayList = new ArrayList(ContainerUtilRt.computeArrayListCapacity(size));
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtilRt.newArrayListWithCapacity must not return null");
        }
        return arrayList;
    }

    private static int computeArrayListCapacity(int size) {
        return 5 + size + size / 5;
    }

    @NotNull
    private static <T, C extends Collection<T>> C copy(@NotNull C collection, @NotNull Iterable<? extends T> elements) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtilRt.copy must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtilRt.copy must not be null");
        }
        for (T element : elements) {
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtilRt.copy must not return null");
        }
        return c;
    }

    @NotNull
    public static <T> java.util.HashSet<T> newHashSet() {
        HashSet hashSet = new HashSet();
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtilRt.newHashSet must not return null");
        }
        return hashSet;
    }

    @NotNull
    public static <T> java.util.HashSet<T> newHashSet(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtilRt.newHashSet must not be null");
        }
        HashSet<T> hashSet = new HashSet<T>(Arrays.asList(elements));
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtilRt.newHashSet must not return null");
        }
        return hashSet;
    }

    @NotNull
    public static <T> Stack<T> newStack() {
        Stack stack = new Stack();
        if (stack == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtilRt.newStack must not return null");
        }
        return stack;
    }

    @NotNull
    public static <T> List<T> emptyList() {
        EmptyList emptyList = EmptyList.INSTANCE;
        if (emptyList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtilRt.emptyList must not return null");
        }
        return emptyList;
    }

    @NotNull
    public static <T> CopyOnWriteArrayList<T> createEmptyCOWList() {
        CopyOnWriteArrayList<T> copyOnWriteArrayList = new CopyOnWriteArrayList<T>(ContainerUtilRt.<T>emptyList());
        if (copyOnWriteArrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtilRt.createEmptyCOWList must not return null");
        }
        return copyOnWriteArrayList;
    }

    public static <T> void addIfNotNull(@Nullable T element, @NotNull Collection<T> result) {
        if (result == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtilRt.addIfNotNull must not be null");
        }
        if (element != null) {
            result.add(element);
        }
    }

    public static <T> void addIfNotNull(@NotNull Collection<T> result, @Nullable T element) {
        if (result == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtilRt.addIfNotNull must not be null");
        }
        if (element != null) {
            result.add(element);
        }
    }

    @NotNull
    public static <T, V> List<V> map2List(@NotNull Collection<? extends T> collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtilRt.map2List must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtilRt.map2List must not be null");
        }
        ArrayList<V> list = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list.add(mapper.fun(t));
        }
        ArrayList<V> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtilRt.map2List must not return null");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> T[] toArray(@NotNull Collection<T> c, @NotNull T[] sample) {
        T[] TArray;
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtilRt.toArray must not be null");
        }
        if (sample == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtilRt.toArray must not be null");
        }
        int size = c.size();
        if (size == sample.length && size < 20) {
            int i = 0;
            for (T t : c) {
                sample[i++] = t;
            }
            TArray = sample;
            if (sample == null) throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtilRt.toArray must not return null");
            return TArray;
        }
        TArray = c.toArray(sample);
        if (TArray != null) return TArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtilRt.toArray must not return null");
    }

    private static class EmptyList<T>
    extends AbstractList<T>
    implements RandomAccess {
        private static final EmptyList INSTANCE = new EmptyList();

        private EmptyList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public T get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        @Override
        @NotNull
        public Object[] toArray() {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtilRt$EmptyList.toArray must not return null");
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }

        @Override
        @NotNull
        public <T> T[] toArray(@NotNull T[] a) {
            if (a == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtilRt$EmptyList.toArray must not be null");
            }
            if (a.length != 0) {
                a[0] = null;
            }
            if (a == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtilRt$EmptyList.toArray must not return null");
            }
            return a;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            EmptyIterator emptyIterator = EmptyIterator.getInstance();
            if (emptyIterator == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtilRt$EmptyList.iterator must not return null");
            }
            return emptyIterator;
        }
    }
}

