/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.HashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiMap<K, V>
implements Serializable {
    public static final MultiMap EMPTY = new MultiMap(){

        protected Map createMap() {
            return Collections.emptyMap();
        }
    };
    protected final Map<K, Collection<V>> myMap = this.createMap();

    protected Map<K, Collection<V>> createMap() {
        return new HashMap();
    }

    protected Collection<V> createCollection() {
        return new ArrayList();
    }

    protected Collection<V> createEmptyCollection() {
        return Collections.emptyList();
    }

    public void putValues(K key, Collection<? extends V> values) {
        Collection<V> list = this.myMap.get(key);
        if (list == null) {
            list = this.createCollection();
            this.myMap.put(key, list);
        }
        list.addAll(values);
    }

    public void putValue(@Nullable K key, V value) {
        Collection<V> list = this.myMap.get(key);
        if (list == null) {
            list = this.createCollection();
            this.myMap.put(key, list);
        }
        list.add(value);
    }

    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        return this.myMap.entrySet();
    }

    @NotNull
    public Collection<V> get(K key) {
        Collection<V> collection = this.myMap.get(key);
        Collection<V> collection2 = collection == null ? this.createEmptyCollection() : collection;
        if (collection2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/MultiMap.get must not return null");
        }
        return collection2;
    }

    public Set<K> keySet() {
        return this.myMap.keySet();
    }

    public void put(K key, Collection<V> values) {
        this.myMap.put(key, values);
    }

    @NotNull
    public static <K, V> MultiMap<K, V> create() {
        MultiMap<K, V> multiMap = new MultiMap<K, V>();
        if (multiMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/MultiMap.create must not return null");
        }
        return multiMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiMap)) {
            return false;
        }
        return ((Object)this.myMap).equals(((MultiMap)o).myMap);
    }

    public int hashCode() {
        return ((Object)this.myMap).hashCode();
    }

    public String toString() {
        return this.myMap.toString();
    }
}

