/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.keyFMap;

import com.intellij.openapi.util.Key;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.keyFMap.PairElementsFMap;
import org.jetbrains.annotations.NotNull;

class OneElementFMap<V>
implements KeyFMap {
    private final int myKeyCode;
    private final V myValue;

    OneElementFMap(int keyCode, @NotNull V value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/keyFMap/OneElementFMap.<init> must not be null");
        }
        this.myKeyCode = keyCode;
        this.myValue = value;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value) {
        KeyFMap keyFMap;
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/keyFMap/OneElementFMap.plus must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/keyFMap/OneElementFMap.plus must not be null");
        }
        int keyCode = key.hashCode();
        if (this.myKeyCode == keyCode) {
            keyFMap = new OneElementFMap<V>(keyCode, value);
            if (keyFMap == null) throw new IllegalStateException("@NotNull method com/intellij/util/keyFMap/OneElementFMap.plus must not return null");
            return keyFMap;
        }
        keyFMap = new PairElementsFMap(this.myKeyCode, this.myValue, keyCode, value);
        if (keyFMap != null) return keyFMap;
        throw new IllegalStateException("@NotNull method com/intellij/util/keyFMap/OneElementFMap.plus must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        KeyFMap keyFMap;
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/keyFMap/OneElementFMap.minus must not be null");
        }
        if (key.hashCode() == this.myKeyCode) {
            keyFMap = KeyFMap.EMPTY_MAP;
            if (keyFMap == null) throw new IllegalStateException("@NotNull method com/intellij/util/keyFMap/OneElementFMap.minus must not return null");
            return keyFMap;
        }
        keyFMap = this;
        if (keyFMap != null) return keyFMap;
        throw new IllegalStateException("@NotNull method com/intellij/util/keyFMap/OneElementFMap.minus must not return null");
    }

    @Override
    public <V> V get(@NotNull Key<V> key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/keyFMap/OneElementFMap.get must not be null");
        }
        return this.myKeyCode == key.hashCode() ? (V)this.myValue : null;
    }

    @Override
    public String toString() {
        return "<" + Key.getKeyByIndex(this.myKeyCode) + " -> " + this.myValue + ">";
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

