/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class LiteralFormatUtil {
    private static final CharFilter UNDERSCORES_FILTER = new CharFilter(){

        @Override
        public boolean accept(char ch) {
            return ch != '_';
        }
    };

    @NotNull
    public static String removeUnderscores(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/LiteralFormatUtil.removeUnderscores must not be null");
        }
        String string = StringUtil.strip(text, UNDERSCORES_FILTER);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/text/LiteralFormatUtil.removeUnderscores must not return null");
        }
        return string;
    }
}

