/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jdom.Text;
import org.jetbrains.annotations.Nullable;

public class AttributeBinding
implements Binding {
    private final Accessor myAccessor;
    private final Attribute myAttribute;
    private Binding myBinding;

    public AttributeBinding(Accessor accessor, Attribute attribute) {
        this.myAccessor = accessor;
        this.myAttribute = attribute;
    }

    @Override
    @Nullable
    public Object deserialize(Object context, Object ... nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xmlb/AttributeBinding.deserialize must not be null");
        }
        assert (nodes.length == 1);
        Object node = nodes[0];
        assert (this.isBoundTo(node));
        org.jdom.Attribute attr = (org.jdom.Attribute)node;
        String value = attr.getValue();
        Text text = new Text(value);
        this.myAccessor.write(context, this.myBinding.deserialize(context, text));
        return context;
    }

    @Override
    public boolean isBoundTo(Object node) {
        return node instanceof org.jdom.Attribute && ((org.jdom.Attribute)node).getName().equals(this.myAttribute.value());
    }

    @Override
    public Class getBoundNodeType() {
        return org.jdom.Attribute.class;
    }

    @Override
    public void init() {
        this.myBinding = XmlSerializerImpl.getBinding(this.myAccessor);
        if (!Text.class.isAssignableFrom(this.myBinding.getBoundNodeType())) {
            throw new XmlSerializationException("Can't use attribute binding for non-text content: " + this.myAccessor);
        }
    }
}

