/*
 * Decompiled with CFR 0.152.
 */
package com.sampullara.cli;

import com.sampullara.cli.Argument;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.PrintStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Args {
    public static List<String> parse(Object target, String[] args) {
        Class<?> clazz;
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.addAll(Arrays.asList(args));
        if (target instanceof Class) {
            clazz = (Class<?>)target;
        } else {
            clazz = target.getClass();
            try {
                BeanInfo info = Introspector.getBeanInfo(clazz);
                for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                    Args.processProperty(target, pd, arguments);
                }
            }
            catch (IntrospectionException info) {
                // empty catch block
            }
        }
        for (Field field : clazz.getDeclaredFields()) {
            Args.processField(target, field, arguments);
        }
        for (String argument : arguments) {
            if (!argument.startsWith("-")) continue;
            throw new IllegalArgumentException("Invalid argument: " + argument);
        }
        return arguments;
    }

    private static void processField(Object target, Field field, List<String> arguments) {
        Argument argument = field.getAnnotation(Argument.class);
        if (argument != null) {
            boolean set = false;
            Iterator<String> i = arguments.iterator();
            while (i.hasNext()) {
                String arg = i.next();
                String prefix = argument.prefix();
                String delimiter = argument.delimiter();
                if (!arg.startsWith(prefix)) continue;
                String name = Args.getName(argument, field);
                String alias = Args.getAlias(argument);
                if ((arg = arg.substring(prefix.length())).equals(name) || alias != null && arg.equals(alias)) {
                    i.remove();
                    Class<?> type = field.getType();
                    Object value = Args.consumeArgumentValue(type, argument, i);
                    Args.setField(type, field, target, value, delimiter);
                    set = true;
                }
                if (!set) continue;
                break;
            }
            if (!set && argument.required()) {
                String name = Args.getName(argument, field);
                throw new IllegalArgumentException("You must set argument " + name);
            }
        }
    }

    private static void processProperty(Object target, PropertyDescriptor property, List<String> arguments) {
        Argument argument;
        Method writeMethod = property.getWriteMethod();
        if (writeMethod != null && (argument = writeMethod.getAnnotation(Argument.class)) != null) {
            boolean set = false;
            Iterator<String> i = arguments.iterator();
            while (i.hasNext()) {
                String arg = i.next();
                String prefix = argument.prefix();
                String delimiter = argument.delimiter();
                if (!arg.startsWith(prefix)) continue;
                String name = Args.getName(argument, property);
                String alias = Args.getAlias(argument);
                if ((arg = arg.substring(prefix.length())).equals(name) || alias != null && arg.equals(alias)) {
                    i.remove();
                    Class<?> type = property.getPropertyType();
                    Object value = Args.consumeArgumentValue(type, argument, i);
                    Args.setProperty(type, property, target, value, delimiter);
                    set = true;
                }
                if (!set) continue;
                break;
            }
            if (!set && argument.required()) {
                String name = Args.getName(argument, property);
                throw new IllegalArgumentException("You must set argument " + name);
            }
        }
    }

    public static void usage(Object target) {
        Args.usage(System.err, target);
    }

    public static void usage(PrintStream errStream, Object target) {
        Class<?> clazz = target instanceof Class ? (Class<?>)target : target.getClass();
        errStream.println("Usage: " + clazz.getName());
        for (Field field : clazz.getDeclaredFields()) {
            Args.fieldUsage(errStream, target, field);
        }
        try {
            BeanInfo info = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                Args.propertyUsage(errStream, target, pd);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }

    private static void fieldUsage(PrintStream errStream, Object target, Field field) {
        Argument argument = field.getAnnotation(Argument.class);
        if (argument != null) {
            String name = Args.getName(argument, field);
            String alias = Args.getAlias(argument);
            String prefix = argument.prefix();
            String delimiter = argument.delimiter();
            String description = argument.description();
            Args.makeAccessible(field);
            try {
                Object defaultValue = field.get(target);
                Class<?> type = field.getType();
                Args.propertyUsage(errStream, prefix, name, alias, type, delimiter, description, defaultValue);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not use thie field " + field + " as an argument field", e);
            }
        }
    }

    private static void propertyUsage(PrintStream errStream, Object target, PropertyDescriptor field) {
        Argument argument;
        Method writeMethod = field.getWriteMethod();
        if (writeMethod != null && (argument = writeMethod.getAnnotation(Argument.class)) != null) {
            String name = Args.getName(argument, field);
            String alias = Args.getAlias(argument);
            String prefix = argument.prefix();
            String delimiter = argument.delimiter();
            String description = argument.description();
            try {
                Method readMethod = field.getReadMethod();
                Object defaultValue = readMethod == null ? null : readMethod.invoke(target, (Object[])null);
                Class<?> type = field.getPropertyType();
                Args.propertyUsage(errStream, prefix, name, alias, type, delimiter, description, defaultValue);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not use thie field " + field + " as an argument field", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Could not get default value for " + field, e);
            }
        }
    }

    private static void propertyUsage(PrintStream errStream, String prefix, String name, String alias, Class type, String delimiter, String description, Object defaultValue) {
        StringBuilder sb = new StringBuilder("  ");
        sb.append(prefix);
        sb.append(name);
        if (alias != null) {
            sb.append(" (");
            sb.append(prefix);
            sb.append(alias);
            sb.append(")");
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            sb.append(" [flag] ");
            sb.append(description);
        } else {
            String typeName;
            sb.append(" [");
            if (type.isArray()) {
                typeName = Args.getTypeName(type.getComponentType());
                sb.append(typeName);
                sb.append("[");
                sb.append(delimiter);
                sb.append("]");
            } else {
                typeName = Args.getTypeName(type);
                sb.append(typeName);
            }
            sb.append("] ");
            sb.append(description);
            if (defaultValue != null) {
                sb.append(" (");
                if (type.isArray()) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    int len = Array.getLength(defaultValue);
                    for (int i = 0; i < len; ++i) {
                        list.add(Array.get(defaultValue, i));
                    }
                    sb.append(list);
                } else {
                    sb.append(defaultValue);
                }
                sb.append(")");
            }
        }
        errStream.println(sb);
    }

    private static String getTypeName(Class type) {
        String typeName = type.getName();
        int beginIndex = typeName.lastIndexOf(".");
        typeName = typeName.substring(beginIndex + 1);
        return typeName;
    }

    static String getName(Argument argument, PropertyDescriptor property) {
        String name = argument.value();
        if (name.equals("")) {
            name = property.getName();
        }
        return name;
    }

    private static Object consumeArgumentValue(Class type, Argument argument, Iterator<String> i) {
        Object value;
        if (type == Boolean.TYPE || type == Boolean.class) {
            value = true;
        } else if (i.hasNext()) {
            value = i.next();
            i.remove();
        } else {
            throw new IllegalArgumentException("Must have a value for non-boolean argument " + argument.value());
        }
        return value;
    }

    static void setProperty(Class type, PropertyDescriptor property, Object target, Object value, String delimiter) {
        try {
            value = Args.getValue(type, value, delimiter);
            property.getWriteMethod().invoke(target, value);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not set property " + property, iae);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find constructor in class " + type.getName() + " that takes a string", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to validate argument " + value + " for " + property);
        }
    }

    static String getAlias(Argument argument) {
        String alias = argument.alias();
        if (alias.equals("")) {
            alias = null;
        }
        return alias;
    }

    static String getName(Argument argument, Field field) {
        String name = argument.value();
        if (name.equals("")) {
            name = field.getName();
        }
        return name;
    }

    static void setField(Class type, Field field, Object target, Object value, String delimiter) {
        Args.makeAccessible(field);
        try {
            value = Args.getValue(type, value, delimiter);
            field.set(target, value);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not set field " + field, iae);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find constructor in class " + type.getName() + " that takes a string", e);
        }
    }

    private static Object getValue(Class type, Object value, String delimiter) throws NoSuchMethodException {
        if (type != String.class && type != Boolean.class && type != Boolean.TYPE) {
            if (type.isArray()) {
                String string = (String)value;
                String[] strings = string.split(delimiter);
                if ((type = type.getComponentType()) == String.class) {
                    value = strings;
                } else {
                    Object[] array = (Object[])Array.newInstance(type, strings.length);
                    for (int i = 0; i < array.length; ++i) {
                        array[i] = Args.createValue(type, strings[i]);
                    }
                    value = array;
                }
            } else {
                value = Args.createValue(type, value);
            }
        }
        return value;
    }

    private static Object createValue(Class type, Object value) throws NoSuchMethodException {
        Constructor init = type.getDeclaredConstructor(String.class);
        try {
            value = init.newInstance(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to convert " + value + " to type " + type.getName(), e);
        }
        return value;
    }

    private static void makeAccessible(AccessibleObject ao) {
        Member member;
        if (ao instanceof Member && !Modifier.isPublic((member = (Member)((Object)ao)).getModifiers())) {
            ao.setAccessible(true);
        }
    }
}

