/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.asJava;

import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ClassFileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.PsiClassHolderFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.asJava.ClsWrapperStubPsiFactory;
import org.jetbrains.jet.asJava.KotlinLightClassBuilderFactory;
import org.jetbrains.jet.asJava.LightClassConstructionContext;
import org.jetbrains.jet.asJava.LightClassGenerationSupport;
import org.jetbrains.jet.asJava.LightClassUtil;
import org.jetbrains.jet.codegen.BuiltinToJavaTypesMapping;
import org.jetbrains.jet.codegen.CompilationErrorHandler;
import org.jetbrains.jet.codegen.NamespaceCodegen;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.Progress;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class KotlinJavaFileStubProvider
implements CachedValueProvider<PsiJavaFileStub> {
    private static final Logger LOG = Logger.getInstance(KotlinJavaFileStubProvider.class);
    private final Project project;
    private final StubGenerationStrategy stubGenerationStrategy;

    @NotNull
    public static KotlinJavaFileStubProvider createForPackageClass(final @NotNull Project project, final @NotNull FqName packageFqName, final @NotNull GlobalSearchScope searchScope) {
        return new KotlinJavaFileStubProvider(project, new StubGenerationStrategy.NoDeclaredClasses(){

            @Override
            @NotNull
            public Collection<JetFile> getFiles() {
                return LightClassGenerationSupport.getInstance(project).findFilesForPackage(packageFqName, searchScope);
            }

            @Override
            @NotNull
            public FqName getPackageFqName() {
                return packageFqName;
            }

            @Override
            public void generate(@NotNull GenerationState state, @NotNull Collection<JetFile> files) {
                NamespaceCodegen codegen = state.getFactory().forNamespace(packageFqName, files);
                codegen.generate(CompilationErrorHandler.THROW_EXCEPTION);
                state.getFactory().files();
            }
        });
    }

    @NotNull
    public static KotlinJavaFileStubProvider createForDeclaredTopLevelClass(final @NotNull JetClassOrObject classOrObject) {
        return new KotlinJavaFileStubProvider(classOrObject.getProject(), new StubGenerationStrategy.WithDeclaredClasses(){

            private JetFile getFile() {
                JetFile file = (JetFile)classOrObject.getContainingFile();
                assert (classOrObject.getParent() == file) : "Not a top-level class: " + classOrObject.getText();
                return file;
            }

            @Override
            @NotNull
            public Collection<JetFile> getFiles() {
                return Collections.singletonList(this.getFile());
            }

            @Override
            @NotNull
            public FqName getPackageFqName() {
                return JetPsiUtil.getFQName(this.getFile());
            }

            @Override
            public void generate(@NotNull GenerationState state, @NotNull Collection<JetFile> files) {
                FqName packageFqName = this.getPackageFqName();
                NamespaceCodegen namespaceCodegen = state.getFactory().forNamespace(packageFqName, files);
                NamespaceDescriptor namespaceDescriptor = state.getBindingContext().get(BindingContext.FQNAME_TO_NAMESPACE_DESCRIPTOR, packageFqName);
                assert (namespaceDescriptor != null) : "No package descriptor for " + packageFqName + " for class " + classOrObject.getText();
                namespaceCodegen.generateClassOrObject(namespaceDescriptor, classOrObject);
                state.getFactory().files();
            }
        });
    }

    private KotlinJavaFileStubProvider(@NotNull Project project, @NotNull StubGenerationStrategy stubGenerationStrategy) {
        this.project = project;
        this.stubGenerationStrategy = stubGenerationStrategy;
    }

    @Override
    @Nullable
    public CachedValueProvider.Result<PsiJavaFileStub> compute() {
        FqName packageFqName = this.stubGenerationStrategy.getPackageFqName();
        Collection<JetFile> files = this.stubGenerationStrategy.getFiles();
        KotlinJavaFileStubProvider.checkForBuiltIns(packageFqName, files);
        LightClassConstructionContext context = LightClassGenerationSupport.getInstance(this.project).analyzeRelevantCode(files);
        Throwable error = context.getError();
        if (error != null) {
            throw new IllegalStateException("failed to analyze: " + error, error);
        }
        PsiJavaFileStub javaFileStub = this.createJavaFileStub(packageFqName, KotlinJavaFileStubProvider.getRepresentativeVirtualFile(files));
        try {
            Stack<StubElement> stubStack = new Stack<StubElement>();
            stubStack.push(javaFileStub);
            GenerationState state = new GenerationState(this.project, new KotlinLightClassBuilderFactory(stubStack), Progress.DEAF, context.getBindingContext(), Lists.newArrayList(files), BuiltinToJavaTypesMapping.ENABLED, false, false, this.stubGenerationStrategy.generateDeclaredClasses());
            state.beforeCompile();
            this.stubGenerationStrategy.generate(state, files);
            StubElement pop = stubStack.pop();
            if (pop != javaFileStub) {
                LOG.error("Unbalanced stack operations: " + pop);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            KotlinJavaFileStubProvider.logErrorWithOSInfo(e, packageFqName, null);
            throw e;
        }
        return CachedValueProvider.Result.create(javaFileStub, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
    }

    @NotNull
    private PsiJavaFileStub createJavaFileStub(final @NotNull FqName packageFqName, @NotNull VirtualFile virtualFile) {
        PsiManager manager = PsiManager.getInstance(this.project);
        final PsiJavaFileStubImpl javaFileStub = new PsiJavaFileStubImpl(packageFqName.asString(), true);
        javaFileStub.setPsiFactory(new ClsWrapperStubPsiFactory());
        ClsFileImpl fakeFile = new ClsFileImpl((PsiManagerImpl)manager, new ClassFileViewProvider(manager, virtualFile)){

            @Override
            @NotNull
            public PsiClassHolderFileStub getStub() {
                return javaFileStub;
            }

            @Override
            @NotNull
            public String getPackageName() {
                return packageFqName.asString();
            }
        };
        fakeFile.setPhysical(false);
        javaFileStub.setPsi(fakeFile);
        return javaFileStub;
    }

    @NotNull
    private static VirtualFile getRepresentativeVirtualFile(@NotNull Collection<JetFile> files) {
        VirtualFile virtualFile;
        JetFile firstFile = files.iterator().next();
        VirtualFile virtualFile2 = virtualFile = files.size() == 1 ? firstFile.getVirtualFile() : new LightVirtualFile();
        assert (virtualFile != null) : "No virtual file for " + firstFile;
        return virtualFile;
    }

    private static void checkForBuiltIns(@NotNull FqName fqName, @NotNull Collection<JetFile> files) {
        for (JetFile file : files) {
            if (!LightClassUtil.belongsToKotlinBuiltIns(file)) continue;
            KotlinJavaFileStubProvider.logErrorWithOSInfo(null, fqName, file.getVirtualFile());
        }
    }

    private static void logErrorWithOSInfo(@Nullable Throwable cause, @NotNull FqName fqName, @Nullable VirtualFile virtualFile) {
        String path = virtualFile == null ? "<null>" : virtualFile.getPath();
        LOG.error("Could not generate LightClass for " + fqName + " declared in " + path + "\n" + "built-ins dir URL is " + LightClassUtil.getBuiltInsDirResourceUrl() + "\n" + "System: " + SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION + " Java Runtime: " + SystemInfo.JAVA_RUNTIME_VERSION, cause);
    }

    private static interface StubGenerationStrategy {
        @NotNull
        public Collection<JetFile> getFiles();

        @NotNull
        public FqName getPackageFqName();

        public boolean generateDeclaredClasses();

        public void generate(@NotNull GenerationState var1, @NotNull Collection<JetFile> var2);

        public static abstract class WithDeclaredClasses
        implements StubGenerationStrategy {
            @Override
            public boolean generateDeclaredClasses() {
                return true;
            }

            public String toString() {
                return WithDeclaredClasses.class.getSimpleName();
            }
        }

        public static abstract class NoDeclaredClasses
        implements StubGenerationStrategy {
            @Override
            public boolean generateDeclaredClasses() {
                return false;
            }

            public String toString() {
                return NoDeclaredClasses.class.getSimpleName();
            }
        }
    }
}

