/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common.messages;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.MessageCollector;

public class GroupingMessageCollector
implements MessageCollector {
    private final MessageCollector delegate;
    private final Multimap<String, Message> groupedMessages = LinkedHashMultimap.create();

    public GroupingMessageCollector(@NotNull MessageCollector delegate) {
        this.delegate = delegate;
    }

    @Override
    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
        if (CompilerMessageSeverity.VERBOSE.contains((Object)severity)) {
            this.delegate.report(severity, message, location);
        } else {
            this.groupedMessages.put(location.getPath(), new Message(severity, message, location));
        }
    }

    public void flush() {
        for (String path : this.groupedMessages.keySet()) {
            Collection<Message> messages = this.groupedMessages.get(path);
            for (Message message : messages) {
                this.delegate.report(message.severity, message.message, message.location);
            }
        }
        this.groupedMessages.clear();
    }

    private static class Message {
        private final CompilerMessageSeverity severity;
        private final String message;
        private final CompilerMessageLocation location;

        private Message(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
            this.severity = severity;
            this.message = message;
            this.location = location;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Message message1 = (Message)o;
            if (!this.location.equals(message1.location)) {
                return false;
            }
            if (!this.message.equals(message1.message)) {
                return false;
            }
            return this.severity == message1.severity;
        }

        public int hashCode() {
            int result = this.severity.hashCode();
            result = 31 * result + this.message.hashCode();
            result = 31 * result + this.location.hashCode();
            return result;
        }
    }
}

