/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common.messages;

import java.io.PrintStream;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.common.messages.MessageRenderer;

public class MessageCollectorPlainTextToStream
implements MessageCollector {
    public static final EnumSet<CompilerMessageSeverity> VERBOSE = EnumSet.of(CompilerMessageSeverity.LOGGING, CompilerMessageSeverity.OUTPUT);
    public static final EnumSet<CompilerMessageSeverity> NON_VERBOSE = EnumSet.complementOf(VERBOSE);
    public static final MessageCollector PLAIN_TEXT_TO_SYSTEM_ERR = new MessageCollectorPlainTextToStream(System.err, NON_VERBOSE);
    @NotNull
    private final PrintStream stream;
    @NotNull
    private final Set<CompilerMessageSeverity> severitiesToPrint;

    public MessageCollectorPlainTextToStream(@NotNull PrintStream stream, @NotNull Set<CompilerMessageSeverity> severities) {
        this.stream = stream;
        this.severitiesToPrint = severities;
    }

    @Override
    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
        if (this.severitiesToPrint.contains((Object)severity)) {
            this.stream.println(MessageRenderer.PLAIN.render(severity, message, location));
        }
    }
}

