/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.js;

import com.sampullara.cli.Argument;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.cli.common.CompilerArguments;
import org.jetbrains.k2js.facade.MainCallParameters;

public class K2JSCompilerArguments
extends CompilerArguments {
    @Argument(value="output", description="Output file path")
    public String outputFile;
    @Argument(value="libraryFiles", description="Path to zipped lib sources or kotlin files")
    public String[] libraryFiles;
    @Argument(value="sourceFiles", description="Source files (dir or file)")
    public String[] sourceFiles;
    @Argument(value="target", description="Generate js files for specific ECMA version (3 or 5, default ECMA 3)")
    public String target;
    @Argument(value="tags", description="Demarcate each compilation message (error, warning, etc) with an open and close tag")
    public boolean tags;
    @Argument(value="verbose", description="Enable verbose logging output")
    public boolean verbose;
    @Argument(value="version", description="Display compiler version")
    public boolean version;
    @Argument(value="main", description="Whether a main function should be called; either 'call' or 'noCall', default 'call' (main function will be auto detected)")
    @Nullable
    public String main;
    @Argument(value="help", alias="h", description="Show help")
    public boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public boolean isTags() {
        return this.tags;
    }

    @Override
    public boolean isVersion() {
        return this.version;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public String getSrc() {
        throw new IllegalStateException();
    }

    public MainCallParameters createMainCallParameters() {
        if ("noCall".equals(this.main)) {
            return MainCallParameters.noCall();
        }
        return MainCallParameters.mainWithoutArguments();
    }
}

