/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm.compiler;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import jet.modules.AllModules;
import jet.modules.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.cli.common.CLIConfigurationKeys;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.common.messages.MessageRenderer;
import org.jetbrains.jet.cli.common.modules.ModuleDescription;
import org.jetbrains.jet.cli.common.modules.ModuleXmlParser;
import org.jetbrains.jet.cli.jvm.JVMConfigurationKeys;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.jet.cli.jvm.compiler.JetCoreEnvironment;
import org.jetbrains.jet.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.jet.cli.jvm.compiler.ModuleExecutionException;
import org.jetbrains.jet.codegen.ClassFileFactory;
import org.jetbrains.jet.codegen.GeneratedClassLoader;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.config.CommonConfigurationKeys;
import org.jetbrains.jet.config.CompilerConfiguration;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.utils.KotlinPaths;
import org.jetbrains.jet.utils.PathUtil;

public class CompileEnvironmentUtil {
    public static Disposable createMockDisposable() {
        return new Disposable(){

            @Override
            public void dispose() {
            }
        };
    }

    @Nullable
    private static File getRuntimeJarPath() {
        File runtimePath = PathUtil.getKotlinPathsForCompiler().getRuntimePath();
        return runtimePath.exists() ? runtimePath : null;
    }

    @NotNull
    public static List<Module> loadModuleDescriptions(KotlinPaths paths, String moduleDefinitionFile, MessageCollector messageCollector) {
        File file = new File(moduleDefinitionFile);
        if (!file.exists()) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Module definition file does not exist: " + moduleDefinitionFile, CompilerMessageLocation.NO_LOCATION);
            return Collections.emptyList();
        }
        String extension = FileUtilRt.getExtension(moduleDefinitionFile);
        if ("kts".equalsIgnoreCase(extension)) {
            return CompileEnvironmentUtil.loadModuleScript(paths, moduleDefinitionFile, messageCollector);
        }
        if ("xml".equalsIgnoreCase(extension)) {
            return ContainerUtil.map(ModuleXmlParser.parse(moduleDefinitionFile, messageCollector), new Function<ModuleDescription, Module>(){

                @Override
                public Module fun(ModuleDescription description) {
                    return new DescriptionToModuleAdapter(description);
                }
            });
        }
        messageCollector.report(CompilerMessageSeverity.ERROR, "Unknown module definition type: " + moduleDefinitionFile, CompilerMessageLocation.NO_LOCATION);
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static List<Module> loadModuleScript(KotlinPaths paths, String moduleScriptFile, MessageCollector messageCollector) {
        List<Module> modules;
        Disposable disposable = new Disposable(){

            @Override
            public void dispose() {
            }
        };
        CompilerConfiguration configuration = new CompilerConfiguration();
        File runtimePath = paths.getRuntimePath();
        if (runtimePath.exists()) {
            configuration.add(JVMConfigurationKeys.CLASSPATH_KEY, runtimePath);
        }
        configuration.add(JVMConfigurationKeys.CLASSPATH_KEY, PathUtil.findRtJar());
        File jdkAnnotationsPath = paths.getJdkAnnotationsPath();
        if (jdkAnnotationsPath.exists()) {
            configuration.add(JVMConfigurationKeys.ANNOTATIONS_PATH_KEY, jdkAnnotationsPath);
        }
        configuration.add(CommonConfigurationKeys.SOURCE_ROOTS_KEY, moduleScriptFile);
        configuration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, messageCollector);
        try {
            JetCoreEnvironment scriptEnvironment = new JetCoreEnvironment(disposable, configuration);
            GenerationState generationState = KotlinToJVMBytecodeCompiler.analyzeAndGenerate(scriptEnvironment, false);
            if (generationState == null) {
                throw new CompileEnvironmentException("Module script " + moduleScriptFile + " analyze failed:\n" + CompileEnvironmentUtil.loadModuleScriptText(moduleScriptFile));
            }
            modules = CompileEnvironmentUtil.runDefineModules(paths, moduleScriptFile, generationState.getFactory());
        }
        finally {
            Disposer.dispose(disposable);
        }
        if (modules == null) {
            throw new CompileEnvironmentException("Module script " + moduleScriptFile + " compilation failed");
        }
        if (modules.isEmpty()) {
            throw new CompileEnvironmentException("No modules where defined by " + moduleScriptFile);
        }
        return modules;
    }

    private static List<Module> runDefineModules(KotlinPaths paths, String moduleFile, ClassFileFactory factory) {
        GeneratedClassLoader loader;
        File stdlibJar = paths.getRuntimePath();
        if (stdlibJar.exists()) {
            try {
                loader = new GeneratedClassLoader(factory, (ClassLoader)new URLClassLoader(new URL[]{stdlibJar.toURI().toURL()}, AllModules.class.getClassLoader()), new URL[0]);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        } else {
            loader = new GeneratedClassLoader(factory, KotlinToJVMBytecodeCompiler.class.getClassLoader(), new URL[0]);
        }
        try {
            Class<?> namespaceClass = loader.loadClass(PackageClassUtils.getPackageClassName(FqName.ROOT));
            Method method = namespaceClass.getDeclaredMethod("project", new Class[0]);
            if (method == null) {
                throw new CompileEnvironmentException("Module script " + moduleFile + " must define project() function");
            }
            method.setAccessible(true);
            method.invoke(null, new Object[0]);
            ArrayList<Module> answer = new ArrayList<Module>((Collection)AllModules.modules.get());
            AllModules.modules.get().clear();
            ArrayList<Module> arrayList = answer;
            return arrayList;
        }
        catch (Exception e) {
            throw new ModuleExecutionException(e);
        }
        finally {
            loader.dispose();
        }
    }

    public static void writeToJar(ClassFileFactory factory, OutputStream fos, @Nullable FqName mainClass, boolean includeRuntime) {
        try {
            Manifest manifest = new Manifest();
            Attributes mainAttributes = manifest.getMainAttributes();
            mainAttributes.putValue("Manifest-Version", "1.0");
            mainAttributes.putValue("Created-By", "JetBrains Kotlin");
            if (mainClass != null) {
                mainAttributes.putValue("Main-Class", mainClass.asString());
            }
            JarOutputStream stream = new JarOutputStream(fos, manifest);
            for (String file : factory.files()) {
                stream.putNextEntry(new JarEntry(file));
                stream.write(factory.asBytes(file));
            }
            if (includeRuntime) {
                CompileEnvironmentUtil.writeRuntimeToJar(stream);
            }
            stream.finish();
        }
        catch (IOException e) {
            throw new CompileEnvironmentException("Failed to generate jar file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRuntimeToJar(JarOutputStream stream) throws IOException {
        block6: {
            File runtimeJarPath = CompileEnvironmentUtil.getRuntimeJarPath();
            if (runtimeJarPath != null) {
                JarInputStream jis = new JarInputStream(new FileInputStream(runtimeJarPath));
                try {
                    while (true) {
                        JarEntry e;
                        if ((e = jis.getNextJarEntry()) == null) {
                            break block6;
                        }
                        if (!FileUtilRt.extensionEquals(e.getName(), "class")) continue;
                        stream.putNextEntry(e);
                        FileUtil.copy(jis, stream);
                    }
                }
                finally {
                    jis.close();
                }
            }
            throw new CompileEnvironmentException("Couldn't find runtime library");
        }
    }

    public static void writeToOutputDirectory(ClassFileFactory factory, @NotNull File outputDir) {
        List<String> files = factory.files();
        for (String file : files) {
            File target = new File(outputDir, file);
            try {
                FileUtil.writeToFile(target, factory.asBytes(file));
            }
            catch (IOException e) {
                throw new CompileEnvironmentException(e);
            }
        }
    }

    private static String loadModuleScriptText(String moduleScriptFile) {
        String moduleScriptText;
        try {
            moduleScriptText = FileUtil.loadFile(new File(moduleScriptFile));
        }
        catch (IOException e) {
            moduleScriptText = "Can't load module script text:\n" + MessageRenderer.PLAIN.renderException(e);
        }
        return moduleScriptText;
    }

    private static class DescriptionToModuleAdapter
    implements Module {
        private final ModuleDescription description;

        public DescriptionToModuleAdapter(ModuleDescription description) {
            this.description = description;
        }

        @Override
        public String getModuleName() {
            return this.description.getModuleName();
        }

        @Override
        public List<String> getSourceFiles() {
            return this.description.getSourceFiles();
        }

        @Override
        public List<String> getClasspathRoots() {
            return this.description.getClasspathRoots();
        }

        @Override
        public List<String> getAnnotationsRoots() {
            return this.description.getAnnotationsRoots();
        }
    }
}

