/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.InstructionAdapter;
import org.jetbrains.asm4.util.Printer;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.Callable;
import org.jetbrains.jet.codegen.signature.JvmMethodSignature;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;

public class CallableMethod
implements Callable {
    @NotNull
    private final JvmClassName owner;
    @Nullable
    private final JvmClassName defaultImplOwner;
    @Nullable
    private final JvmClassName defaultImplParam;
    private final JvmMethodSignature signature;
    private final int invokeOpcode;
    @Nullable
    private final JvmClassName thisClass;
    @Nullable
    private final Type receiverParameterType;
    @Nullable
    private final Type generateCalleeType;

    public CallableMethod(@NotNull JvmClassName owner, @Nullable JvmClassName defaultImplOwner, @Nullable JvmClassName defaultImplParam, JvmMethodSignature signature, int invokeOpcode, @Nullable JvmClassName thisClass, @Nullable Type receiverParameterType, @Nullable Type generateCalleeType) {
        this.owner = owner;
        this.defaultImplOwner = defaultImplOwner;
        this.defaultImplParam = defaultImplParam;
        this.signature = signature;
        this.invokeOpcode = invokeOpcode;
        this.thisClass = thisClass;
        this.receiverParameterType = receiverParameterType;
        this.generateCalleeType = generateCalleeType;
    }

    @NotNull
    public JvmClassName getOwner() {
        return this.owner;
    }

    @Nullable
    public JvmClassName getDefaultImplParam() {
        return this.defaultImplParam;
    }

    public JvmMethodSignature getSignature() {
        return this.signature;
    }

    public int getInvokeOpcode() {
        return this.invokeOpcode;
    }

    public List<Type> getValueParameterTypes() {
        return this.signature.getValueParameterTypes();
    }

    @Nullable
    public JvmClassName getThisType() {
        return this.thisClass;
    }

    @Nullable
    public Type getReceiverClass() {
        return this.receiverParameterType;
    }

    private void invoke(InstructionAdapter v) {
        v.visitMethodInsn(this.getInvokeOpcode(), this.owner.getInternalName(), this.getSignature().getAsmMethod().getName(), this.getSignature().getAsmMethod().getDescriptor());
    }

    public void invokeWithNotNullAssertion(@NotNull InstructionAdapter v, @NotNull GenerationState state, @NotNull ResolvedCall resolvedCall) {
        this.invokeWithoutAssertions(v);
        AsmUtil.genNotNullAssertionForMethod(v, state, resolvedCall);
    }

    public void invokeWithoutAssertions(@NotNull InstructionAdapter v) {
        this.invoke(v);
    }

    @Nullable
    public Type getGenerateCalleeType() {
        return this.generateCalleeType;
    }

    private void invokeDefault(InstructionAdapter v, int mask) {
        if (this.defaultImplOwner == null || this.defaultImplParam == null) {
            throw new IllegalStateException();
        }
        v.iconst(mask);
        String desc = this.getSignature().getAsmMethod().getDescriptor().replace(")", "I)");
        if ("<init>".equals(this.getSignature().getAsmMethod().getName())) {
            v.visitMethodInsn(183, this.defaultImplOwner.getInternalName(), "<init>", desc);
        } else {
            if (this.getInvokeOpcode() != 184) {
                desc = desc.replace("(", "(" + this.defaultImplParam.getDescriptor());
            }
            v.visitMethodInsn(184, this.defaultImplOwner.getInternalName(), this.getSignature().getAsmMethod().getName() + "$default", desc);
        }
    }

    public void invokeDefaultWithNotNullAssertion(@NotNull InstructionAdapter v, @NotNull GenerationState state, @NotNull ResolvedCall resolvedCall, int mask) {
        this.invokeDefault(v, mask);
        AsmUtil.genNotNullAssertionForMethod(v, state, resolvedCall);
    }

    public boolean isNeedsThis() {
        return this.thisClass != null && this.generateCalleeType == null;
    }

    public Type getReturnType() {
        return this.signature.getAsmMethod().getReturnType();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Printer.OPCODES[this.invokeOpcode]);
        sb.append(" ");
        sb.append(this.owner);
        sb.append(".");
        sb.append(this.signature);
        return sb.toString();
    }
}

