/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.InstructionAdapter;
import org.jetbrains.asm4.commons.Method;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FieldInfo;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.FunctionGenerationStrategy;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.binding.CalculatedClosure;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.LocalLookup;
import org.jetbrains.jet.codegen.signature.BothSignatureWriter;
import org.jetbrains.jet.codegen.signature.JvmMethodSignature;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.GenerationStateAware;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.codegen.state.JetTypeMapperMode;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class ClosureCodegen
extends GenerationStateAware {
    private final PsiElement fun;
    private final FunctionDescriptor funDescriptor;
    private final ClassDescriptor samInterface;
    private final JvmClassName superClass;
    private final CodegenContext context;
    private final FunctionGenerationStrategy strategy;
    private final CalculatedClosure closure;
    private final JvmClassName name;
    private Method constructor;

    public ClosureCodegen(@NotNull GenerationState state, @NotNull PsiElement fun, @NotNull FunctionDescriptor funDescriptor, @Nullable ClassDescriptor samInterface, @NotNull JvmClassName closureSuperClass, @NotNull CodegenContext context, @NotNull LocalLookup localLookup, @NotNull FunctionGenerationStrategy strategy) {
        super(state);
        this.fun = fun;
        this.funDescriptor = funDescriptor;
        this.samInterface = samInterface;
        this.superClass = closureSuperClass;
        this.context = context.intoClosure(funDescriptor, localLookup, this.typeMapper);
        this.strategy = strategy;
        ClassDescriptor classDescriptor = CodegenBinding.anonymousClassForFunction(this.bindingContext, funDescriptor);
        this.closure = this.bindingContext.get(CodegenBinding.CLOSURE, classDescriptor);
        assert (this.closure != null) : "Closure must be calculated for class: " + classDescriptor;
        this.name = CodegenBinding.classNameForAnonymousClass(this.bindingContext, funDescriptor);
    }

    public void gen() {
        String[] superInterfaces;
        FunctionDescriptor interfaceFunction;
        ClassBuilder cv = this.state.getFactory().newVisitor(this.name.getInternalName(), this.fun.getContainingFile());
        if (this.samInterface == null) {
            interfaceFunction = ClosureCodegen.getInvokeFunction(this.funDescriptor);
            superInterfaces = ArrayUtil.EMPTY_STRING_ARRAY;
        } else {
            interfaceFunction = SingleAbstractMethodUtils.getAbstractMethodOfSamInterface(this.samInterface);
            superInterfaces = new String[]{JvmClassName.byClassDescriptor(this.samInterface).getInternalName()};
        }
        cv.defineClass(this.fun, 50, 48, this.name.getInternalName(), this.getGenericSignature(), this.superClass.getInternalName(), superInterfaces);
        cv.visitSource(this.fun.getContainingFile().getName(), null);
        this.generateBridge(interfaceFunction, cv);
        JvmMethodSignature jvmMethodSignature = this.typeMapper.mapSignature(interfaceFunction.getName(), this.funDescriptor);
        FunctionCodegen fc = new FunctionCodegen(this.context, cv, this.state);
        fc.generateMethod(this.fun, jvmMethodSignature, false, this.funDescriptor, this.strategy);
        this.constructor = this.generateConstructor(cv);
        if (CodegenUtil.isConst(this.closure)) {
            this.generateConstInstance(cv);
        }
        AsmUtil.genClosureFields(this.closure, cv, this.typeMapper);
        cv.done();
    }

    @NotNull
    public StackValue putInstanceOnStack(@NotNull InstructionAdapter v, @NotNull ExpressionCodegen codegen) {
        Type asmType = this.name.getAsmType();
        if (CodegenUtil.isConst(this.closure)) {
            v.getstatic(this.name.getInternalName(), "instance$", this.name.getDescriptor());
        } else {
            v.anew(asmType);
            v.dup();
            codegen.pushClosureOnStack(this.closure, false);
            v.invokespecial(this.name.getInternalName(), "<init>", this.constructor.getDescriptor());
        }
        return StackValue.onStack(asmType);
    }

    private void generateConstInstance(@NotNull ClassBuilder cv) {
        MethodVisitor mv = cv.newMethod(this.fun, 4104, "<clinit>", "()V", null, ArrayUtil.EMPTY_STRING_ARRAY);
        InstructionAdapter iv = new InstructionAdapter(mv);
        cv.newField(this.fun, 24, "instance$", this.name.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.STUBS) {
            AsmUtil.genStubCode(mv);
        } else if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            mv.visitCode();
            AsmUtil.genInitSingletonField(this.name.getAsmType(), iv);
            mv.visitInsn(177);
            FunctionCodegen.endVisit(mv, "<clinit>", this.fun);
        }
    }

    private void generateBridge(@NotNull FunctionDescriptor interfaceFunction, @NotNull ClassBuilder cv) {
        Method bridge = this.typeMapper.mapSignature(interfaceFunction).getAsmMethod();
        Method delegate = this.typeMapper.mapSignature(interfaceFunction.getName(), this.funDescriptor).getAsmMethod();
        if (bridge.getDescriptor().equals(delegate.getDescriptor())) {
            return;
        }
        MethodVisitor mv = cv.newMethod(this.fun, 65, interfaceFunction.getName().asString(), bridge.getDescriptor(), null, ArrayUtil.EMPTY_STRING_ARRAY);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.STUBS) {
            AsmUtil.genStubCode(mv);
        }
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            mv.visitCode();
            InstructionAdapter iv = new InstructionAdapter(mv);
            iv.load(0, this.name.getAsmType());
            ReceiverParameterDescriptor receiver = this.funDescriptor.getReceiverParameter();
            int count = 1;
            if (receiver != null) {
                StackValue.local(count, bridge.getArgumentTypes()[count - 1]).put(this.typeMapper.mapType(receiver.getType()), iv);
                ++count;
            }
            List<ValueParameterDescriptor> params = this.funDescriptor.getValueParameters();
            for (ValueParameterDescriptor param : params) {
                StackValue.local(count, bridge.getArgumentTypes()[count - 1]).put(this.typeMapper.mapType(param.getType()), iv);
                ++count;
            }
            iv.invokevirtual(this.name.getInternalName(), interfaceFunction.getName().asString(), delegate.getDescriptor());
            StackValue.onStack(delegate.getReturnType()).put(bridge.getReturnType(), iv);
            iv.areturn(bridge.getReturnType());
            FunctionCodegen.endVisit(mv, "bridge", this.fun);
        }
    }

    @NotNull
    private Method generateConstructor(@NotNull ClassBuilder cv) {
        List<FieldInfo> args = ClosureCodegen.calculateConstructorParameters(this.typeMapper, this.closure, this.name.getAsmType());
        Type[] argTypes = ClosureCodegen.fieldListToTypeArray(args);
        Method constructor = new Method("<init>", Type.VOID_TYPE, argTypes);
        MethodVisitor mv = cv.newMethod(this.fun, 0, "<init>", constructor.getDescriptor(), null, ArrayUtil.EMPTY_STRING_ARRAY);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.STUBS) {
            AsmUtil.genStubCode(mv);
        } else if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            mv.visitCode();
            InstructionAdapter iv = new InstructionAdapter(mv);
            iv.load(0, this.superClass.getAsmType());
            iv.invokespecial(this.superClass.getInternalName(), "<init>", "()V");
            int k = 1;
            for (FieldInfo fieldInfo : args) {
                k = AsmUtil.genAssignInstanceFieldFromParam(fieldInfo, k, iv);
            }
            iv.visitInsn(177);
            FunctionCodegen.endVisit(iv, "constructor", this.fun);
        }
        return constructor;
    }

    @NotNull
    public static List<FieldInfo> calculateConstructorParameters(@NotNull JetTypeMapper typeMapper, @NotNull CalculatedClosure closure, @NotNull Type ownerType) {
        ClassifierDescriptor captureReceiver;
        BindingContext bindingContext = typeMapper.getBindingContext();
        ArrayList<FieldInfo> args = Lists.newArrayList();
        ClassDescriptor captureThis = closure.getCaptureThis();
        if (captureThis != null) {
            Type type = typeMapper.mapType(captureThis);
            args.add(FieldInfo.createForHiddenField(ownerType, type, "this$0"));
        }
        if ((captureReceiver = closure.getCaptureReceiver()) != null) {
            args.add(FieldInfo.createForHiddenField(ownerType, typeMapper.mapType(captureReceiver), "receiver$0"));
        }
        for (DeclarationDescriptor descriptor : closure.getCaptureVariables().keySet()) {
            if (descriptor instanceof VariableDescriptor && !(descriptor instanceof PropertyDescriptor)) {
                Type sharedVarType = typeMapper.getSharedVarType(descriptor);
                Type type = sharedVarType != null ? sharedVarType : typeMapper.mapType((VariableDescriptor)descriptor);
                args.add(FieldInfo.createForHiddenField(ownerType, type, "$" + descriptor.getName().asString()));
                continue;
            }
            if (CodegenBinding.isLocalNamedFun(descriptor)) {
                JvmClassName className = CodegenBinding.classNameForAnonymousClass(bindingContext, (FunctionDescriptor)descriptor);
                args.add(FieldInfo.createForHiddenField(ownerType, className.getAsmType(), "$" + descriptor.getName().asString()));
                continue;
            }
            if (descriptor instanceof FunctionDescriptor) assert (captureReceiver != null);
        }
        return args;
    }

    private static Type[] fieldListToTypeArray(List<FieldInfo> args) {
        Type[] argTypes = new Type[args.size()];
        for (int i = 0; i != argTypes.length; ++i) {
            argTypes[i] = args.get(i).getFieldType();
        }
        return argTypes;
    }

    @NotNull
    private String getGenericSignature() {
        ClassDescriptor classDescriptor = CodegenBinding.anonymousClassForFunction(this.bindingContext, this.funDescriptor);
        Collection<JetType> supertypes = classDescriptor.getTypeConstructor().getSupertypes();
        assert (supertypes.size() == 1) : "Closure must have exactly one supertype: " + this.funDescriptor;
        JetType supertype = supertypes.iterator().next();
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.CLASS, true);
        this.typeMapper.writeFormalTypeParameters(Collections.<TypeParameterDescriptor>emptyList(), sw);
        sw.writeSupersStart();
        sw.writeSuperclass();
        this.typeMapper.mapType(supertype, sw, JetTypeMapperMode.TYPE_PARAMETER);
        sw.writeSuperclassEnd();
        sw.writeSupersEnd();
        String signature = sw.makeJavaGenericSignature();
        assert (signature != null) : "Closure superclass must have a generic signature: " + this.funDescriptor;
        return signature;
    }

    private static FunctionDescriptor getInvokeFunction(FunctionDescriptor funDescriptor) {
        int paramCount = funDescriptor.getValueParameters().size();
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        ClassDescriptor funClass = funDescriptor.getReceiverParameter() == null ? builtIns.getFunction(paramCount) : builtIns.getExtensionFunction(paramCount);
        return funClass.getDefaultType().getMemberScope().getFunctions(Name.identifier("invoke")).iterator().next();
    }
}

