/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;

public class FieldInfo {
    private final Type fieldType;
    private final Type ownerType;
    private final String fieldName;
    private final boolean isStatic;

    @NotNull
    public static FieldInfo createForSingleton(@NotNull ClassDescriptor fieldClassDescriptor, @NotNull JetTypeMapper typeMapper) {
        ClassDescriptor ownerDescriptor;
        ClassKind kind = fieldClassDescriptor.getKind();
        if (kind != ClassKind.OBJECT && kind != ClassKind.CLASS_OBJECT && kind != ClassKind.ENUM_ENTRY) {
            throw new UnsupportedOperationException();
        }
        Type fieldType = typeMapper.mapType(fieldClassDescriptor.getDefaultType());
        ClassDescriptor classDescriptor = ownerDescriptor = kind == ClassKind.OBJECT ? fieldClassDescriptor : DescriptorUtils.getParentOfType(fieldClassDescriptor, ClassDescriptor.class);
        assert (ownerDescriptor != null);
        Type ownerType = typeMapper.mapType(ownerDescriptor.getDefaultType());
        String fieldName = kind == ClassKind.ENUM_ENTRY ? fieldClassDescriptor.getName().asString() : (fieldClassDescriptor.getKind() == ClassKind.CLASS_OBJECT ? "object$" : "instance$");
        return new FieldInfo(ownerType, fieldType, fieldName, true);
    }

    public static FieldInfo createForHiddenField(@NotNull Type owner, Type fieldType, String fieldName) {
        return new FieldInfo(owner, fieldType, fieldName, false);
    }

    private FieldInfo(@NotNull Type ownerType, @NotNull Type fieldType, @NotNull String fieldName, @NotNull boolean isStatic) {
        this.ownerType = ownerType;
        this.fieldType = fieldType;
        this.fieldName = fieldName;
        this.isStatic = isStatic;
    }

    @NotNull
    public Type getFieldType() {
        return this.fieldType;
    }

    @NotNull
    public Type getOwnerType() {
        return this.ownerType;
    }

    @NotNull
    public String getOwnerInternalName() {
        return this.ownerType.getInternalName();
    }

    @NotNull
    public String getFieldName() {
        return this.fieldName;
    }

    @NotNull
    public boolean isStatic() {
        return this.isStatic;
    }
}

