/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.context.MethodContext;
import org.jetbrains.jet.codegen.signature.JvmMethodSignature;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;

public abstract class FunctionGenerationStrategy {
    private final Collection<String> localVariableNames = new ArrayList<String>();
    private FrameMap frameMap;

    public abstract void generateBody(@NotNull MethodVisitor var1, @NotNull JvmMethodSignature var2, @NotNull MethodContext var3);

    protected void addLocalVariableName(@NotNull String name) {
        this.localVariableNames.add(name);
    }

    @NotNull
    public Collection<String> getLocalVariableNames() {
        return this.localVariableNames;
    }

    @NotNull
    protected FrameMap createFrameMap(@NotNull JetTypeMapper typeMapper, @NotNull MethodContext context) {
        return context.prepareFrame(typeMapper);
    }

    @NotNull
    public FrameMap getFrameMap(@NotNull JetTypeMapper typeMapper, @NotNull MethodContext context) {
        if (this.frameMap == null) {
            this.frameMap = this.createFrameMap(typeMapper, context);
        }
        return this.frameMap;
    }

    public static abstract class CodegenBased<T extends CallableDescriptor>
    extends FunctionGenerationStrategy {
        protected final GenerationState state;
        protected final T callableDescriptor;

        public CodegenBased(@NotNull GenerationState state, T callableDescriptor) {
            this.state = state;
            this.callableDescriptor = callableDescriptor;
        }

        @Override
        public void generateBody(@NotNull MethodVisitor mv, @NotNull JvmMethodSignature signature, @NotNull MethodContext context) {
            ExpressionCodegen codegen = this.initializeExpressionCodegen(signature, context, mv, signature.getAsmMethod().getReturnType());
            this.doGenerateBody(codegen, signature);
            this.generateLocalVarNames(codegen);
        }

        public abstract void doGenerateBody(@NotNull ExpressionCodegen var1, @NotNull JvmMethodSignature var2);

        @NotNull
        public ExpressionCodegen initializeExpressionCodegen(JvmMethodSignature signature, MethodContext context, MethodVisitor mv, Type returnType) {
            return new ExpressionCodegen(mv, this.getFrameMap(this.state.getTypeMapper(), context), returnType, context, this.state);
        }

        public void generateLocalVarNames(@NotNull ExpressionCodegen codegen) {
            for (String name : codegen.getLocalVariableNamesForExpression()) {
                this.addLocalVariableName(name);
            }
        }
    }

    public static class FunctionDefault
    extends CodegenBased<CallableDescriptor> {
        private final JetDeclarationWithBody declaration;

        public FunctionDefault(@NotNull GenerationState state, @NotNull CallableDescriptor descriptor, @NotNull JetDeclarationWithBody declaration) {
            super(state, descriptor);
            this.declaration = declaration;
        }

        @Override
        public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
            codegen.returnExpression(this.declaration.getBodyExpression());
        }
    }
}

