/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.asm4.AnnotationVisitor;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.ClassBuilderOnDemand;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.CompilationErrorHandler;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.ImplementationBodyCodegen;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.FieldOwnerContext;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.JvmStdlibNames;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public class NamespaceCodegen
extends MemberCodegen {
    @NotNull
    private final ClassBuilderOnDemand v;
    @NotNull
    private final FqName name;
    private final Collection<JetFile> files;

    public NamespaceCodegen(@NotNull ClassBuilderOnDemand v, final @NotNull FqName fqName, GenerationState state, Collection<JetFile> namespaceFiles) {
        super(state, null);
        NamespaceCodegen.checkAllFilesHaveSameNamespace(namespaceFiles);
        this.v = v;
        this.name = fqName;
        this.files = namespaceFiles;
        final PsiFile sourceFile = namespaceFiles.size() == 1 ? namespaceFiles.iterator().next().getContainingFile() : null;
        v.addOptionalDeclaration(new ClassBuilderOnDemand.ClassBuilderCallback(){

            @Override
            public void doSomething(@NotNull ClassBuilder v) {
                v.defineClass(sourceFile, 50, 17, NamespaceCodegen.getJVMClassNameForKotlinNs(fqName).getInternalName(), null, "java/lang/Object", new String[0]);
                if (sourceFile != null) {
                    v.visitSource(sourceFile.getName(), null);
                }
            }
        });
    }

    public void generate(CompilationErrorHandler errorHandler) {
        if (NamespaceCodegen.shouldGenerateNSClass(this.files)) {
            AnnotationVisitor packageClassAnnotation = this.v.getClassBuilder().newAnnotation(JvmStdlibNames.JET_PACKAGE_CLASS.getDescriptor(), true);
            packageClassAnnotation.visit("abiVersion", 6);
            packageClassAnnotation.visitEnd();
        }
        for (JetFile file : this.files) {
            VirtualFile vFile = file.getVirtualFile();
            try {
                this.generate(file);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                if (errorHandler != null) {
                    errorHandler.reportException(e, vFile == null ? "no file" : vFile.getUrl());
                }
                DiagnosticUtils.throwIfRunningOnServer(e);
                if (!ApplicationManager.getApplication().isInternal()) continue;
                e.printStackTrace();
            }
        }
        assert (this.v.isActivated() == NamespaceCodegen.shouldGenerateNSClass(this.files)) : "Different algorithms for generating namespace class and for heuristics";
    }

    private void generate(JetFile file) {
        NamespaceDescriptor descriptor = this.state.getBindingContext().get(BindingContext.FILE_TO_NAMESPACE, file);
        assert (descriptor != null) : "No namespace found for file " + file + " declared package: " + file.getPackageName();
        int countOfDeclarationsInSrcClass = 0;
        for (JetDeclaration declaration : file.getDeclarations()) {
            if (declaration instanceof JetProperty || declaration instanceof JetNamedFunction) {
                ++countOfDeclarationsInSrcClass;
                continue;
            }
            if (declaration instanceof JetClassOrObject) {
                if (!this.state.isGenerateDeclaredClasses()) continue;
                this.generateClassOrObject(descriptor, (JetClassOrObject)declaration);
                continue;
            }
            if (!(declaration instanceof JetScript)) continue;
            this.state.getScriptCodegen().generate((JetScript)declaration);
        }
        if (countOfDeclarationsInSrcClass > 0) {
            String namespaceInternalName = JvmClassName.byFqNameWithoutInnerClasses(PackageClassUtils.getPackageClassFqName(this.name)).getInternalName();
            String className = NamespaceCodegen.getMultiFileNamespaceInternalName(namespaceInternalName, file);
            ClassBuilder builder = this.state.getFactory().forNamespacepart(className, file);
            builder.defineClass(file, 50, 17, className, null, "java/lang/Object", new String[0]);
            builder.visitSource(file.getName(), null);
            FieldOwnerContext nameSpaceContext = CodegenContext.STATIC.intoNamespace(descriptor);
            FieldOwnerContext nameSpacePart = CodegenContext.STATIC.intoNamespacePart(className, descriptor);
            for (JetDeclaration declaration : file.getDeclarations()) {
                if (!(declaration instanceof JetNamedFunction) && !(declaration instanceof JetProperty)) continue;
                this.genFunctionOrProperty(nameSpaceContext, (JetTypeParameterListOwner)declaration, builder);
                this.genFunctionOrProperty(nameSpacePart, (JetTypeParameterListOwner)declaration, this.v.getClassBuilder());
            }
            this.generateStaticInitializers(descriptor, builder, file, nameSpaceContext);
            builder.done();
        }
    }

    public void generateClassOrObject(@NotNull NamespaceDescriptor descriptor, @NotNull JetClassOrObject classOrObject) {
        FieldOwnerContext context = CodegenContext.STATIC.intoNamespace(descriptor);
        this.genClassOrObject(context, classOrObject);
    }

    public static boolean shouldGenerateNSClass(Collection<JetFile> namespaceFiles) {
        NamespaceCodegen.checkAllFilesHaveSameNamespace(namespaceFiles);
        for (JetFile file : namespaceFiles) {
            for (JetDeclaration declaration : file.getDeclarations()) {
                if (!(declaration instanceof JetProperty) && !(declaration instanceof JetNamedFunction)) continue;
                return true;
            }
        }
        return false;
    }

    private static void checkAllFilesHaveSameNamespace(Collection<JetFile> namespaceFiles) {
        FqName commonFqName = null;
        for (JetFile file : namespaceFiles) {
            FqName fqName = JetPsiUtil.getFQName(file);
            if (commonFqName != null) {
                if (commonFqName.equals(fqName)) continue;
                throw new IllegalArgumentException("All files should have same package name");
            }
            commonFqName = JetPsiUtil.getFQName(file);
        }
    }

    private void generateStaticInitializers(NamespaceDescriptor descriptor, @NotNull ClassBuilder builder, @NotNull JetFile file, @NotNull FieldOwnerContext context) {
        List<JetProperty> properties = this.collectPropertiesToInitialize(file);
        if (properties.isEmpty()) {
            return;
        }
        MethodVisitor mv = builder.newMethod(file, 8, "<clinit>", "()V", null, null);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            mv.visitCode();
            FrameMap frameMap = new FrameMap();
            SimpleFunctionDescriptorImpl clInit = new SimpleFunctionDescriptorImpl(descriptor, Collections.<AnnotationDescriptor>emptyList(), Name.special("<clinit>"), CallableMemberDescriptor.Kind.SYNTHESIZED);
            clInit.initialize(null, null, Collections.emptyList(), Collections.<ValueParameterDescriptor>emptyList(), null, null, Visibilities.PRIVATE, false);
            ExpressionCodegen codegen = new ExpressionCodegen(mv, frameMap, Type.VOID_TYPE, context.intoFunction(clInit), this.state);
            for (JetDeclaration jetDeclaration : properties) {
                ImplementationBodyCodegen.initializeProperty(codegen, this.state.getBindingContext(), (JetProperty)jetDeclaration);
            }
            mv.visitInsn(177);
            FunctionCodegen.endVisit(mv, "static initializer for namespace", file);
            mv.visitEnd();
        }
    }

    @NotNull
    private List<JetProperty> collectPropertiesToInitialize(@NotNull JetFile file) {
        ArrayList<JetProperty> result = Lists.newArrayList();
        for (JetDeclaration declaration : file.getDeclarations()) {
            if (!(declaration instanceof JetProperty) || !ImplementationBodyCodegen.shouldInitializeProperty((JetProperty)declaration, this.typeMapper)) continue;
            result.add((JetProperty)declaration);
        }
        return result;
    }

    public void done() {
        this.v.done();
    }

    @NotNull
    public static JvmClassName getJVMClassNameForKotlinNs(@NotNull FqName fqName) {
        String packageClassName = PackageClassUtils.getPackageClassName(fqName);
        if (fqName.isRoot()) {
            return JvmClassName.byInternalName(packageClassName);
        }
        return JvmClassName.byFqNameWithoutInnerClasses(fqName.child(Name.identifier(packageClassName)));
    }

    @NotNull
    private static String getMultiFileNamespaceInternalName(@NotNull String namespaceInternalName, @NotNull PsiFile file) {
        String fileName = FileUtil.getNameWithoutExtension(PathUtil.getFileName(file.getName()));
        return namespaceInternalName + "$src$" + NamespaceCodegen.replaceSpecialSymbols(fileName) + "$" + Integer.toHexString(CodegenUtil.getPathHashCode(file));
    }

    private static String replaceSpecialSymbols(@NotNull String str) {
        return str.replace('.', '_');
    }

    @NotNull
    public static String getNamespacePartInternalName(@NotNull JetFile file) {
        FqName fqName = JetPsiUtil.getFQName(file);
        JvmClassName namespaceJvmClassName = NamespaceCodegen.getJVMClassNameForKotlinNs(fqName);
        String namespaceInternalName = namespaceJvmClassName.getInternalName();
        return NamespaceCodegen.getMultiFileNamespaceInternalName(namespaceInternalName, file);
    }
}

