/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.signature;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.Method;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterKind;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterSignature;

public class JvmMethodSignature {
    @NotNull
    private final Method asmMethod;
    private final String genericsSignature;
    private final String kotlinTypeParameter;
    @NotNull
    private final List<JvmMethodParameterSignature> kotlinParameterTypes;
    @NotNull
    private final String kotlinReturnType;
    private final boolean genericsAvailable;

    protected JvmMethodSignature(@NotNull Method asmMethod, @Nullable String genericsSignature, @Nullable String kotlinTypeParameters, @NotNull List<JvmMethodParameterSignature> kotlinParameterTypes, @NotNull String kotlinReturnType, boolean genericsAvailable) {
        this.asmMethod = asmMethod;
        this.genericsSignature = genericsSignature;
        this.kotlinTypeParameter = kotlinTypeParameters;
        this.kotlinParameterTypes = kotlinParameterTypes;
        this.kotlinReturnType = kotlinReturnType;
        this.genericsAvailable = genericsAvailable;
    }

    private void checkGenericsAvailable() {
        if (!this.genericsAvailable) {
            // empty if block
        }
    }

    @NotNull
    public Method getAsmMethod() {
        return this.asmMethod;
    }

    public String getGenericsSignature() {
        this.checkGenericsAvailable();
        return this.genericsSignature;
    }

    public String getKotlinTypeParameter() {
        this.checkGenericsAvailable();
        return this.kotlinTypeParameter;
    }

    @NotNull
    public List<JvmMethodParameterSignature> getKotlinParameterTypes() {
        this.checkGenericsAvailable();
        return this.kotlinParameterTypes;
    }

    public int getParameterCount() {
        return this.asmMethod.getArgumentTypes().length;
    }

    @NotNull
    public String getKotlinParameterType(int i) {
        this.checkGenericsAvailable();
        return this.kotlinParameterTypes.get(i).getKotlinSignature();
    }

    @NotNull
    public String getKotlinReturnType() {
        this.checkGenericsAvailable();
        return this.kotlinReturnType;
    }

    public List<Type> getValueParameterTypes() {
        ArrayList<Type> r = new ArrayList<Type>(this.kotlinParameterTypes.size());
        for (JvmMethodParameterSignature p : this.kotlinParameterTypes) {
            if (p.getKind() != JvmMethodParameterKind.VALUE) continue;
            r.add(p.getAsmType());
        }
        return r;
    }

    @NotNull
    public String getName() {
        return this.asmMethod.getName();
    }

    public String toString() {
        return this.asmMethod.toString();
    }
}

