/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.cfg.Label;
import org.jetbrains.jet.lang.cfg.pseudocode.AbstractJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;
import org.jetbrains.jet.lang.cfg.pseudocode.JetElementInstruction;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetThrowExpression;

public class ThrowExceptionInstruction
extends AbstractJumpInstruction
implements JetElementInstruction {
    private final JetThrowExpression expression;

    public ThrowExceptionInstruction(@NotNull JetThrowExpression expression, @NotNull Label errorLabel) {
        super(errorLabel);
        this.expression = expression;
    }

    @Override
    @NotNull
    public JetExpression getElement() {
        return this.expression;
    }

    public String toString() {
        return "throw (" + this.expression.getText() + ")";
    }

    @Override
    public void accept(InstructionVisitor visitor) {
        visitor.visitThrowExceptionInstruction(this);
    }

    @Override
    protected AbstractJumpInstruction createCopy(@NotNull Label newLabel) {
        return new ThrowExceptionInstruction(this.expression, newLabel);
    }
}

