/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetNamedDeclarationStub;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.stubs.PsiJetParameterStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lexer.JetTokens;

public class JetParameter
extends JetNamedDeclarationStub<PsiJetParameterStub> {
    public static final JetParameter[] EMPTY_ARRAY = new JetParameter[0];
    public static final ArrayFactory<JetParameter> ARRAY_FACTORY = new ArrayFactory<JetParameter>(){

        public JetParameter[] create(int count) {
            return count == 0 ? EMPTY_ARRAY : new JetParameter[count];
        }
    };

    public JetParameter(@NotNull ASTNode node) {
        super(node);
    }

    public JetParameter(@NotNull PsiJetParameterStub stub, @NotNull IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    @NotNull
    public IStubElementType getElementType() {
        return JetStubElementTypes.VALUE_PARAMETER;
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        visitor.visitParameter(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        return visitor.visitParameter(this, data);
    }

    @Nullable
    public JetTypeReference getTypeReference() {
        return (JetTypeReference)this.findChildByType(JetNodeTypes.TYPE_REFERENCE);
    }

    @Nullable
    public JetExpression getDefaultValue() {
        boolean passedEQ = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JetTokens.EQ) {
                passedEQ = true;
            }
            if (!passedEQ || !(child.getPsi() instanceof JetExpression)) continue;
            return (JetExpression)child.getPsi();
        }
        return null;
    }

    public boolean isMutable() {
        PsiJetParameterStub stub = (PsiJetParameterStub)this.getStub();
        if (stub != null) {
            return stub.isMutable();
        }
        return this.findChildByType(JetTokens.VAR_KEYWORD) != null;
    }

    public boolean isVarArg() {
        PsiJetParameterStub stub = (PsiJetParameterStub)this.getStub();
        if (stub != null) {
            return stub.isVarArg();
        }
        JetModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.getModifierNode(JetTokens.VARARG_KEYWORD) != null;
    }

    @Nullable
    public ASTNode getValOrVarNode() {
        ASTNode val = this.getNode().findChildByType(JetTokens.VAL_KEYWORD);
        if (val != null) {
            return val;
        }
        return this.getNode().findChildByType(JetTokens.VAR_KEYWORD);
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }
}

