/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.autocasts;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.scopes.receivers.AbstractReceiverValue;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValueVisitor;
import org.jetbrains.jet.lang.types.JetType;

public class AutoCastReceiver
extends AbstractReceiverValue {
    private final ReceiverValue original;
    private final boolean canCast;

    public AutoCastReceiver(@NotNull ReceiverValue original, @NotNull JetType castTo, boolean canCast) {
        super(castTo);
        this.original = original;
        this.canCast = canCast;
    }

    public boolean canCast() {
        return this.canCast;
    }

    @NotNull
    public ReceiverValue getOriginal() {
        return this.original;
    }

    @Override
    public <R, D> R accept(@NotNull ReceiverValueVisitor<R, D> visitor, D data) {
        return this.original.accept(visitor, data);
    }

    public String toString() {
        return "(" + this.original + " as " + this.getType() + ")";
    }
}

