/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.autocasts;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValue;
import org.jetbrains.jet.lang.resolve.calls.autocasts.Nullability;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.util.CommonSuppliers;

class DelegatingDataFlowInfo
implements DataFlowInfo {
    @Nullable
    private final DataFlowInfo parent;
    @NotNull
    private final ImmutableMap<DataFlowValue, Nullability> nullabilityInfo;
    @NotNull
    private final SetMultimap<DataFlowValue, JetType> typeInfo;
    private static final ImmutableMap<DataFlowValue, Nullability> EMPTY_NULLABILITY_INFO = ImmutableMap.copyOf(Collections.emptyMap());
    private static final SetMultimap<DataFlowValue, JetType> EMPTY_TYPE_INFO = DelegatingDataFlowInfo.newTypeInfo();

    DelegatingDataFlowInfo(@Nullable DataFlowInfo parent, @NotNull ImmutableMap<DataFlowValue, Nullability> nullabilityInfo, @NotNull SetMultimap<DataFlowValue, JetType> typeInfo) {
        this.parent = parent;
        this.nullabilityInfo = nullabilityInfo;
        this.typeInfo = typeInfo;
    }

    @NotNull
    private Map<DataFlowValue, Nullability> getCompleteNullabilityInfo() {
        HashMap<DataFlowValue, Nullability> result = Maps.newHashMap();
        DelegatingDataFlowInfo info = this;
        while (info != null) {
            for (Map.Entry entry : info.nullabilityInfo.entrySet()) {
                DataFlowValue key = (DataFlowValue)entry.getKey();
                Nullability value = (Nullability)((Object)entry.getValue());
                if (result.containsKey(key)) continue;
                result.put(key, value);
            }
            info = (DelegatingDataFlowInfo)info.parent;
        }
        return result;
    }

    @NotNull
    private SetMultimap<DataFlowValue, JetType> getCompleteTypeInfo() {
        SetMultimap<DataFlowValue, JetType> result = DelegatingDataFlowInfo.newTypeInfo();
        DelegatingDataFlowInfo info = this;
        while (info != null) {
            for (DataFlowValue key : info.typeInfo.keySet()) {
                result.putAll(key, info.typeInfo.get(key));
            }
            info = (DelegatingDataFlowInfo)info.parent;
        }
        return result;
    }

    @Override
    @NotNull
    public Nullability getNullability(@NotNull DataFlowValue key) {
        if (!key.isStableIdentifier()) {
            return key.getImmanentNullability();
        }
        Nullability nullability = this.nullabilityInfo.get(key);
        return nullability != null ? nullability : (this.parent != null ? this.parent.getNullability(key) : key.getImmanentNullability());
    }

    private boolean putNullability(@NotNull Map<DataFlowValue, Nullability> map, @NotNull DataFlowValue value, @NotNull Nullability nullability) {
        if (!value.isStableIdentifier()) {
            return false;
        }
        map.put(value, nullability);
        return nullability != this.getNullability(value);
    }

    @Override
    @NotNull
    public Set<JetType> getPossibleTypes(@NotNull DataFlowValue key) {
        Set<JetType> types = this.typeInfo.get(key);
        if (this.getNullability(key).canBeNull()) {
            return this.parent == null ? types : Sets.union(types, this.parent.getPossibleTypes(key));
        }
        HashSet<JetType> enrichedTypes = Sets.newHashSetWithExpectedSize(types.size() + 1);
        JetType originalType = key.getType();
        if (originalType.isNullable()) {
            enrichedTypes.add(TypeUtils.makeNotNullable(originalType));
        }
        for (JetType type : types) {
            enrichedTypes.add(TypeUtils.makeNotNullable(type));
        }
        return this.parent == null ? enrichedTypes : Sets.union(enrichedTypes, this.parent.getPossibleTypes(key));
    }

    @Override
    @NotNull
    public DataFlowInfo equate(@NotNull DataFlowValue a, @NotNull DataFlowValue b) {
        HashMap<DataFlowValue, Nullability> builder = Maps.newHashMap();
        Nullability nullabilityOfA = this.getNullability(a);
        Nullability nullabilityOfB = this.getNullability(b);
        boolean changed = false;
        changed |= this.putNullability(builder, a, nullabilityOfA.refine(nullabilityOfB));
        return (changed |= this.putNullability(builder, b, nullabilityOfB.refine(nullabilityOfA))) ? new DelegatingDataFlowInfo(this, ImmutableMap.copyOf(builder), EMPTY_TYPE_INFO) : this;
    }

    @Override
    @NotNull
    public DataFlowInfo disequate(@NotNull DataFlowValue a, @NotNull DataFlowValue b) {
        HashMap<DataFlowValue, Nullability> builder = Maps.newHashMap();
        Nullability nullabilityOfA = this.getNullability(a);
        Nullability nullabilityOfB = this.getNullability(b);
        boolean changed = false;
        changed |= this.putNullability(builder, a, nullabilityOfA.refine(nullabilityOfB.invert()));
        return (changed |= this.putNullability(builder, b, nullabilityOfB.refine(nullabilityOfA.invert()))) ? new DelegatingDataFlowInfo(this, ImmutableMap.copyOf(builder), EMPTY_TYPE_INFO) : this;
    }

    @Override
    @NotNull
    public DataFlowInfo establishSubtyping(@NotNull DataFlowValue value, @NotNull JetType type) {
        if (value.getType().equals(type)) {
            return this;
        }
        if (this.getPossibleTypes(value).contains(type)) {
            return this;
        }
        ImmutableMap<DataFlowValue, Nullability> newNullabilityInfo = type.isNullable() ? EMPTY_NULLABILITY_INFO : ImmutableMap.of(value, Nullability.NOT_NULL);
        ImmutableSetMultimap<DataFlowValue, JetType> newTypeInfo = ImmutableSetMultimap.of(value, type);
        return new DelegatingDataFlowInfo(this, newNullabilityInfo, newTypeInfo);
    }

    @Override
    @NotNull
    public DataFlowInfo and(@NotNull DataFlowInfo otherInfo) {
        if (otherInfo == EMPTY) {
            return this;
        }
        if (this == EMPTY) {
            return otherInfo;
        }
        if (this == otherInfo) {
            return this;
        }
        assert (otherInfo instanceof DelegatingDataFlowInfo) : "Unknown DataFlowInfo type: " + otherInfo;
        DelegatingDataFlowInfo other = (DelegatingDataFlowInfo)otherInfo;
        HashMap<DataFlowValue, Nullability> nullabilityMapBuilder = Maps.newHashMap();
        for (Map.Entry<DataFlowValue, Nullability> entry : other.getCompleteNullabilityInfo().entrySet()) {
            DataFlowValue key = entry.getKey();
            Nullability otherFlags = entry.getValue();
            Nullability thisFlags = this.getNullability(key);
            Nullability flags = thisFlags.and(otherFlags);
            if (flags == thisFlags) continue;
            nullabilityMapBuilder.put(key, flags);
        }
        SetMultimap<DataFlowValue, JetType> myTypeInfo = this.getCompleteTypeInfo();
        SetMultimap<DataFlowValue, JetType> otherTypeInfo = other.getCompleteTypeInfo();
        if (nullabilityMapBuilder.isEmpty() && DelegatingDataFlowInfo.containsAll(myTypeInfo, otherTypeInfo)) {
            return this;
        }
        return new DelegatingDataFlowInfo(this, ImmutableMap.copyOf(nullabilityMapBuilder), otherTypeInfo);
    }

    private static boolean containsAll(SetMultimap<DataFlowValue, JetType> first, SetMultimap<DataFlowValue, JetType> second) {
        return first.entries().containsAll(second.entries());
    }

    @Override
    @NotNull
    public DataFlowInfo or(@NotNull DataFlowInfo otherInfo) {
        if (otherInfo == EMPTY) {
            return EMPTY;
        }
        if (this == EMPTY) {
            return EMPTY;
        }
        if (this == otherInfo) {
            return this;
        }
        assert (otherInfo instanceof DelegatingDataFlowInfo) : "Unknown DataFlowInfo type: " + otherInfo;
        DelegatingDataFlowInfo other = (DelegatingDataFlowInfo)otherInfo;
        HashMap<DataFlowValue, Nullability> nullabilityMapBuilder = Maps.newHashMap();
        for (Map.Entry<DataFlowValue, Nullability> entry : other.getCompleteNullabilityInfo().entrySet()) {
            DataFlowValue key = entry.getKey();
            Nullability otherFlags = entry.getValue();
            Nullability thisFlags = this.getNullability(key);
            nullabilityMapBuilder.put(key, thisFlags.or(otherFlags));
        }
        SetMultimap<DataFlowValue, JetType> myTypeInfo = this.getCompleteTypeInfo();
        SetMultimap<DataFlowValue, JetType> otherTypeInfo = other.getCompleteTypeInfo();
        SetMultimap<DataFlowValue, JetType> newTypeInfo = DelegatingDataFlowInfo.newTypeInfo();
        for (DataFlowValue key : Sets.intersection(myTypeInfo.keySet(), otherTypeInfo.keySet())) {
            Set<JetType> thisTypes = myTypeInfo.get(key);
            Set<JetType> otherTypes = otherTypeInfo.get(key);
            newTypeInfo.putAll(key, Sets.intersection(thisTypes, otherTypes));
        }
        if (nullabilityMapBuilder.isEmpty() && newTypeInfo.isEmpty()) {
            return EMPTY;
        }
        return new DelegatingDataFlowInfo(null, ImmutableMap.copyOf(nullabilityMapBuilder), newTypeInfo);
    }

    @NotNull
    static SetMultimap<DataFlowValue, JetType> newTypeInfo() {
        return Multimaps.newSetMultimap(Maps.newHashMap(), CommonSuppliers.getLinkedHashSetSupplier());
    }

    @Override
    public boolean hasTypeInfoConstraints() {
        return !this.typeInfo.isEmpty();
    }

    public String toString() {
        if (this.typeInfo.isEmpty() && this.nullabilityInfo.isEmpty()) {
            return "EMPTY";
        }
        return "Non-trivial DataFlowInfo";
    }
}

