/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.model;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.results.ResolutionStatus;
import org.jetbrains.jet.lang.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeSubstitutor;

public class ResolvedCallImpl<D extends CallableDescriptor>
implements ResolvedCallWithTrace<D> {
    public static final Function<ResolvedCallWithTrace<? extends CallableDescriptor>, CallableDescriptor> MAP_TO_CANDIDATE = new Function<ResolvedCallWithTrace<? extends CallableDescriptor>, CallableDescriptor>(){

        @Override
        public CallableDescriptor fun(ResolvedCallWithTrace<? extends CallableDescriptor> resolvedCall) {
            return resolvedCall.getCandidateDescriptor();
        }
    };
    public static final Function<ResolvedCallWithTrace<? extends CallableDescriptor>, CallableDescriptor> MAP_TO_RESULT = new Function<ResolvedCallWithTrace<? extends CallableDescriptor>, CallableDescriptor>(){

        @Override
        public CallableDescriptor fun(ResolvedCallWithTrace<? extends CallableDescriptor> resolvedCall) {
            return resolvedCall.getResultingDescriptor();
        }
    };
    private final D candidateDescriptor;
    private D resultingDescriptor;
    private final ReceiverValue thisObject;
    private final ReceiverValue receiverArgument;
    private final ExplicitReceiverKind explicitReceiverKind;
    private final boolean isSafeCall;
    private final Map<TypeParameterDescriptor, JetType> typeArguments = Maps.newLinkedHashMap();
    private final Map<ValueParameterDescriptor, ResolvedValueArgument> valueArguments = Maps.newLinkedHashMap();
    private final Set<ValueArgument> unmappedArguments = Sets.newLinkedHashSet();
    private boolean someArgumentHasNoType = false;
    private final DelegatingBindingTrace trace;
    private final TracingStrategy tracing;
    private ResolutionStatus status = ResolutionStatus.UNKNOWN_STATUS;
    private boolean hasUnknownTypeParameters = false;
    private ConstraintSystem constraintSystem = null;
    private DataFlowInfo dataFlowInfo;

    @NotNull
    public static <D extends CallableDescriptor> ResolvedCallImpl<D> create(@NotNull ResolutionCandidate<D> candidate, @NotNull DelegatingBindingTrace trace, @NotNull TracingStrategy tracing) {
        return new ResolvedCallImpl<D>(candidate, trace, tracing);
    }

    private ResolvedCallImpl(@NotNull ResolutionCandidate<D> candidate, @NotNull DelegatingBindingTrace trace, @NotNull TracingStrategy tracing) {
        this.candidateDescriptor = candidate.getDescriptor();
        this.thisObject = candidate.getThisObject();
        this.receiverArgument = candidate.getReceiverArgument();
        this.explicitReceiverKind = candidate.getExplicitReceiverKind();
        this.isSafeCall = candidate.isSafeCall();
        this.trace = trace;
        this.tracing = tracing;
    }

    @Override
    @NotNull
    public ResolutionStatus getStatus() {
        return this.status;
    }

    public void addStatus(@NotNull ResolutionStatus status) {
        this.status = this.status.combine(status);
    }

    public void setStatusToSuccess() {
        assert (this.status == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE || this.status == ResolutionStatus.UNKNOWN_STATUS);
        this.status = ResolutionStatus.SUCCESS;
    }

    @Override
    public boolean hasIncompleteTypeParameters() {
        return this.hasUnknownTypeParameters;
    }

    public void setHasUnknownTypeParameters(boolean hasUnknownTypeParameters) {
        this.hasUnknownTypeParameters = hasUnknownTypeParameters;
    }

    @Override
    @NotNull
    public DelegatingBindingTrace getTrace() {
        return this.trace;
    }

    @NotNull
    public TracingStrategy getTracing() {
        return this.tracing;
    }

    @Override
    @NotNull
    public D getCandidateDescriptor() {
        return this.candidateDescriptor;
    }

    @Override
    @NotNull
    public D getResultingDescriptor() {
        return this.resultingDescriptor == null ? this.candidateDescriptor : this.resultingDescriptor;
    }

    public void setResultingSubstitutor(@NotNull TypeSubstitutor substitutor) {
        this.resultingDescriptor = this.candidateDescriptor.substitute(substitutor);
        assert (this.resultingDescriptor != null) : this.candidateDescriptor;
        HashMap<ValueParameterDescriptor, ValueParameterDescriptor> parameterMap = Maps.newHashMap();
        for (ValueParameterDescriptor valueParameterDescriptor : this.resultingDescriptor.getValueParameters()) {
            parameterMap.put(valueParameterDescriptor.getOriginal(), valueParameterDescriptor);
        }
        LinkedHashMap<ValueParameterDescriptor, ResolvedValueArgument> originalValueArguments = Maps.newLinkedHashMap(this.valueArguments);
        this.valueArguments.clear();
        for (Map.Entry entry : originalValueArguments.entrySet()) {
            ValueParameterDescriptor substitutedVersion = (ValueParameterDescriptor)parameterMap.get(((ValueParameterDescriptor)entry.getKey()).getOriginal());
            assert (substitutedVersion != null) : (ValueParameterDescriptor)entry.getKey();
            this.valueArguments.put(substitutedVersion, (ResolvedValueArgument)entry.getValue());
        }
    }

    public void recordTypeArgument(@NotNull TypeParameterDescriptor typeParameter, @NotNull JetType typeArgument) {
        assert (!this.typeArguments.containsKey(typeParameter)) : typeParameter + " -> " + typeArgument;
        this.typeArguments.put(typeParameter, typeArgument);
    }

    public void setConstraintSystem(@NotNull ConstraintSystem constraintSystem) {
        this.constraintSystem = constraintSystem;
    }

    @Nullable
    public ConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    public void recordValueArgument(@NotNull ValueParameterDescriptor valueParameter, @NotNull ResolvedValueArgument valueArgument) {
        assert (!this.valueArguments.containsKey(valueParameter)) : valueParameter + " -> " + valueArgument;
        this.valueArguments.put(valueParameter, valueArgument);
    }

    public void setUnmappedArguments(@NotNull Collection<ValueArgument> unmappedArguments) {
        this.unmappedArguments.addAll(unmappedArguments);
    }

    @NotNull
    public Set<ValueArgument> getUnmappedArguments() {
        return this.unmappedArguments;
    }

    @Override
    @NotNull
    public ReceiverValue getReceiverArgument() {
        return this.receiverArgument;
    }

    @Override
    @NotNull
    public ReceiverValue getThisObject() {
        return this.thisObject;
    }

    @Override
    @NotNull
    public ExplicitReceiverKind getExplicitReceiverKind() {
        return this.explicitReceiverKind;
    }

    @Override
    @NotNull
    public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
        return this.valueArguments;
    }

    @Override
    @NotNull
    public List<ResolvedValueArgument> getValueArgumentsByIndex() {
        ArrayList<ResolvedValueArgument> arguments = new ArrayList<ResolvedValueArgument>(this.candidateDescriptor.getValueParameters().size());
        for (int i = 0; i < this.candidateDescriptor.getValueParameters().size(); ++i) {
            arguments.add(null);
        }
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : this.valueArguments.entrySet()) {
            if (arguments.set(entry.getKey().getIndex(), entry.getValue()) == null) continue;
            throw new IllegalStateException();
        }
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : arguments) {
            if (entry != null) continue;
            throw new IllegalStateException();
        }
        return arguments;
    }

    public void argumentHasNoType() {
        this.someArgumentHasNoType = true;
    }

    @Override
    public boolean isDirty() {
        return this.someArgumentHasNoType;
    }

    @Override
    @NotNull
    public Map<TypeParameterDescriptor, JetType> getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public boolean isSafeCall() {
        return this.isSafeCall;
    }

    @Override
    @NotNull
    public DataFlowInfo getDataFlowInfo() {
        return this.dataFlowInfo;
    }

    public void setInitialDataFlowInfo(@NotNull DataFlowInfo info) {
        assert (this.dataFlowInfo == null);
        this.dataFlowInfo = info;
    }

    public void addDataFlowInfo(@NotNull DataFlowInfo info) {
        assert (this.dataFlowInfo != null);
        this.dataFlowInfo = this.dataFlowInfo.and(info);
    }

    @Override
    @NotNull
    public ResolvedCallImpl<D> getCallToCompleteTypeArgumentInference() {
        return this;
    }
}

