/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.google.common.base.Predicate;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.resolve.name.FqName;

public abstract class JetFilesProvider {
    public static JetFilesProvider getInstance(Project project) {
        return ServiceManager.getService(project, JetFilesProvider.class);
    }

    public final Function<JetFile, List<JetFile>> allNamespaceFiles() {
        return new Function<JetFile, List<JetFile>>(){

            @Override
            public List<JetFile> fun(JetFile file) {
                return new SameJetFilePredicate(file).filter(JetFilesProvider.this.sampleToAllFilesInModule().fun(file));
            }
        };
    }

    public abstract Function<JetFile, Collection<JetFile>> sampleToAllFilesInModule();

    public abstract Collection<JetFile> allInScope(GlobalSearchScope var1);

    public static class SameJetFilePredicate
    implements Predicate<PsiFile> {
        private final FqName name;

        public SameJetFilePredicate(JetFile file) {
            this.name = JetPsiUtil.getFQName(file);
        }

        @Override
        public boolean apply(PsiFile psiFile) {
            return JetPsiUtil.getFQName((JetFile)psiFile).equals(this.name);
        }

        public List<JetFile> filter(Collection<JetFile> allFiles) {
            LinkedList<JetFile> files = new LinkedList<JetFile>();
            for (JetFile aFile : allFiles) {
                if (!this.apply(aFile)) continue;
                files.add(aFile);
            }
            return files;
        }
    }
}

