/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kt;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.JvmStdlibNames;
import org.jetbrains.jet.lang.resolve.java.kt.PsiAnnotationWithAbiVersion;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;

public class JetClassAnnotation
extends PsiAnnotationWithAbiVersion {
    private static final JetClassAnnotation NULL_ANNOTATION = new JetClassAnnotation(null);
    private String signature;

    private JetClassAnnotation(@Nullable PsiAnnotation psiAnnotation) {
        super(psiAnnotation);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.signature = this.getStringAttribute("signature", "");
    }

    @NotNull
    public String signature() {
        this.checkInitialized();
        return this.signature;
    }

    public int kind() {
        return this.flags() & 0x1C0;
    }

    @NotNull
    public static JetClassAnnotation get(PsiClass psiClass) {
        PsiAnnotation annotation = JavaAnnotationResolver.findOwnAnnotation(psiClass, JvmStdlibNames.JET_CLASS.getFqName().asString());
        return annotation != null ? new JetClassAnnotation(annotation) : NULL_ANNOTATION;
    }

    static {
        NULL_ANNOTATION.checkInitialized();
    }
}

