/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kt;

import com.intellij.psi.PsiAnnotation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.kt.PsiAnnotationUtils;

public abstract class PsiAnnotationWrapper {
    @Nullable
    private final PsiAnnotation psiAnnotation;
    private boolean initialized = false;

    protected PsiAnnotationWrapper(@Nullable PsiAnnotation psiAnnotation) {
        this.psiAnnotation = psiAnnotation;
    }

    public boolean isDefined() {
        return this.psiAnnotation != null;
    }

    protected abstract void initialize();

    protected void checkInitialized() {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
    }

    @NotNull
    protected String getStringAttribute(String name, String defaultValue) {
        return PsiAnnotationUtils.getStringAttribute(this.psiAnnotation, name, defaultValue);
    }

    protected boolean getBooleanAttribute(String name, boolean defaultValue) {
        return PsiAnnotationUtils.getBooleanAttribute(this.psiAnnotation, name, defaultValue);
    }

    protected int getIntAttribute(String name, int defaultValue) {
        return PsiAnnotationUtils.getIntAttribute(this.psiAnnotation, name, defaultValue);
    }
}

