/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.provider;

import com.intellij.psi.PsiClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.PsiClassFinder;
import org.jetbrains.jet.lang.resolve.java.provider.ClassPsiDeclarationProvider;
import org.jetbrains.jet.lang.resolve.java.provider.DeclarationOrigin;
import org.jetbrains.jet.lang.resolve.java.provider.MembersCache;
import org.jetbrains.jet.lang.resolve.java.provider.PsiDeclarationProviderBase;

public class ClassPsiDeclarationProviderImpl
extends PsiDeclarationProviderBase
implements ClassPsiDeclarationProvider {
    @NotNull
    protected final DeclarationOrigin declarationOrigin;
    @NotNull
    protected final PsiClassFinder psiClassFinder;
    @NotNull
    private final PsiClass psiClass;
    private final boolean staticMembers;

    protected ClassPsiDeclarationProviderImpl(@NotNull PsiClass psiClass, boolean staticMembers, @NotNull PsiClassFinder psiClassFinder) {
        this.staticMembers = staticMembers;
        this.psiClass = psiClass;
        this.psiClassFinder = psiClassFinder;
        this.declarationOrigin = ClassPsiDeclarationProviderImpl.determineOrigin(psiClass);
    }

    @Override
    @NotNull
    protected MembersCache buildMembersCache() {
        return MembersCache.buildMembersByNameCache(new MembersCache(), this.psiClassFinder, this.psiClass, null, this.staticMembers, this.getDeclarationOrigin() == DeclarationOrigin.KOTLIN);
    }

    @Override
    @NotNull
    public PsiClass getPsiClass() {
        return this.psiClass;
    }

    @Override
    @NotNull
    public DeclarationOrigin getDeclarationOrigin() {
        return this.declarationOrigin;
    }

    @NotNull
    private static DeclarationOrigin determineOrigin(@Nullable PsiClass psiClass) {
        return psiClass != null && DescriptorResolverUtils.isKotlinClass(psiClass) ? DeclarationOrigin.KOTLIN : DeclarationOrigin.JAVA;
    }

    @Override
    public boolean isStaticMembers() {
        return this.staticMembers;
    }
}

