/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.provider;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.JetJavaMirrorMarker;
import org.jetbrains.jet.lang.resolve.java.PsiClassFinder;
import org.jetbrains.jet.lang.resolve.java.TypeSource;
import org.jetbrains.jet.lang.resolve.java.kt.JetClassAnnotation;
import org.jetbrains.jet.lang.resolve.java.prop.PropertyNameUtils;
import org.jetbrains.jet.lang.resolve.java.prop.PropertyParseResult;
import org.jetbrains.jet.lang.resolve.java.provider.NamedMembers;
import org.jetbrains.jet.lang.resolve.java.wrapper.PropertyPsiDataElement;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiClassWrapper;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiFieldWrapper;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiMemberWrapper;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiMethodWrapper;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiParameterWrapper;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public final class MembersCache {
    private static final ImmutableSet<String> OBJECT_METHODS = ImmutableSet.of("hashCode()", "equals(java.lang.Object)", "toString()");
    private final Multimap<Name, Runnable> memberProcessingTasks = HashMultimap.create();
    private final Map<Name, NamedMembers> namedMembersMap = new HashMap<Name, NamedMembers>();

    @Nullable
    public NamedMembers get(@NotNull Name name) {
        this.runTasksByName(name);
        return this.namedMembersMap.get(name);
    }

    @NotNull
    public Collection<NamedMembers> allMembers() {
        this.runAllTasks();
        this.memberProcessingTasks.clear();
        return this.namedMembersMap.values();
    }

    @NotNull
    private NamedMembers getOrCreateEmpty(@NotNull Name name) {
        NamedMembers r = this.namedMembersMap.get(name);
        if (r == null) {
            r = new NamedMembers(name);
            this.namedMembersMap.put(name, r);
        }
        return r;
    }

    private void addTask(@NotNull PsiMember member, @NotNull RunOnce task) {
        this.addTask(member.getName(), task);
    }

    private void addTask(@Nullable String name, @NotNull RunOnce task) {
        if (name == null) {
            return;
        }
        this.memberProcessingTasks.put(Name.identifier(name), task);
    }

    private void runTasksByName(Name name) {
        if (!this.memberProcessingTasks.containsKey(name)) {
            return;
        }
        Collection<Runnable> tasks = this.memberProcessingTasks.get(name);
        for (Runnable task : tasks) {
            task.run();
        }
        tasks.clear();
    }

    private void runAllTasks() {
        for (Runnable task : this.memberProcessingTasks.values()) {
            task.run();
        }
    }

    @NotNull
    public static MembersCache buildMembersByNameCache(@NotNull MembersCache membersCache, @NotNull PsiClassFinder finder, @Nullable PsiClass psiClass, @Nullable PsiPackage psiPackage, boolean staticMembers, boolean isKotlin) {
        if (psiClass != null) {
            MembersCache membersCache2 = membersCache;
            membersCache2.getClass();
            membersCache2.new ClassMemberProcessor(new PsiClassWrapper(psiClass), staticMembers, isKotlin).process();
        }
        List<PsiClass> classes = psiPackage != null ? finder.findPsiClasses(psiPackage) : finder.findInnerPsiClasses(psiClass);
        MembersCache membersCache3 = membersCache;
        membersCache3.getClass();
        membersCache3.new ExtraPackageMembersProcessor(classes).process();
        return membersCache;
    }

    public static boolean isObjectMethodInInterface(@NotNull PsiMember member) {
        if (!(member instanceof PsiMethod)) {
            return false;
        }
        PsiClass containingClass = member.getContainingClass();
        assert (containingClass != null) : "containing class is null for " + member;
        if (!containingClass.isInterface()) {
            return false;
        }
        return MembersCache.isObjectMethod((PsiMethod)member);
    }

    private static boolean isObjectMethod(PsiMethod method) {
        String formattedMethod = PsiFormatUtil.formatMethod(method, PsiSubstitutor.EMPTY, 257, 8194);
        return OBJECT_METHODS.contains(formattedMethod);
    }

    public static boolean isSamInterface(@NotNull PsiClass psiClass) {
        return MembersCache.getSamInterfaceMethod(psiClass) != null;
    }

    @Nullable
    public static PsiMethod getSamInterfaceMethod(@NotNull PsiClass psiClass) {
        if (DescriptorResolverUtils.isKotlinClass(psiClass)) {
            return null;
        }
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName == null || qualifiedName.startsWith(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME.asString() + ".")) {
            return null;
        }
        if (!psiClass.isInterface() || psiClass.isAnnotationType()) {
            return null;
        }
        return MembersCache.findOnlyAbstractMethod(psiClass);
    }

    @Nullable
    private static PsiMethod findOnlyAbstractMethod(@NotNull PsiClass psiClass) {
        OnlyAbstractMethodFinder finder = new OnlyAbstractMethodFinder();
        PsiClassType classType = JavaPsiFacade.getElementFactory(psiClass.getProject()).createType(psiClass);
        if (finder.find(classType)) {
            return finder.getFoundMethod();
        }
        return null;
    }

    private static boolean isVarargMethod(@NotNull PsiMethod method) {
        PsiParameter lastParameter = ArrayUtil.getLastElement(method.getParameterList().getParameters());
        return lastParameter != null && lastParameter.getType() instanceof PsiEllipsisType;
    }

    private static class OnlyAbstractMethodFinder {
        private MethodSignatureBackedByPsiMethod found;

        private OnlyAbstractMethodFinder() {
        }

        private boolean find(@NotNull PsiClassType classType) {
            PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
            PsiSubstitutor classSubstitutor = classResolveResult.getSubstitutor();
            PsiClass psiClass = classResolveResult.getElement();
            if (psiClass == null) {
                return false;
            }
            if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
                return true;
            }
            for (PsiMethod method : psiClass.getMethods()) {
                if (MembersCache.isObjectMethod(method)) continue;
                if (method.hasTypeParameters()) {
                    return false;
                }
                if (this.found == null) {
                    this.found = (MethodSignatureBackedByPsiMethod)method.getSignature(classSubstitutor);
                    continue;
                }
                if (!this.found.getName().equals(method.getName())) {
                    return false;
                }
                MethodSignatureBackedByPsiMethod current = (MethodSignatureBackedByPsiMethod)method.getSignature(classSubstitutor);
                if (MethodSignatureUtil.areSignaturesErasureEqual(current, this.found) && MembersCache.isVarargMethod(method) == MembersCache.isVarargMethod(this.found.getMethod())) continue;
                return false;
            }
            for (PsiType t : classType.getSuperTypes()) {
                if (this.find((PsiClassType)t)) continue;
                return false;
            }
            return true;
        }

        @Nullable
        PsiMethod getFoundMethod() {
            return this.found == null ? null : this.found.getMethod();
        }
    }

    private static abstract class RunOnce
    implements Runnable {
        private boolean hasRun = false;

        private RunOnce() {
        }

        @Override
        public final void run() {
            if (this.hasRun) {
                return;
            }
            this.hasRun = true;
            this.doRun();
        }

        protected abstract void doRun();
    }

    private class ClassMemberProcessor {
        @NotNull
        private final PsiClassWrapper psiClass;
        private final boolean staticMembers;
        private final boolean kotlin;

        private ClassMemberProcessor(@NotNull PsiClassWrapper psiClass, boolean staticMembers, boolean kotlin) {
            this.psiClass = psiClass;
            this.staticMembers = staticMembers;
            this.kotlin = kotlin;
        }

        public void process() {
            this.processFields();
            this.processMethods();
            this.processNestedClasses();
        }

        private void processFields() {
            if (this.kotlin && !this.psiClass.getPsiClass().isEnum()) {
                return;
            }
            for (final PsiField field : this.psiClass.getPsiClass().getAllFields()) {
                MembersCache.this.addTask(field, new RunOnce(){

                    @Override
                    public void doRun() {
                        ClassMemberProcessor.this.processField(field);
                    }
                });
            }
        }

        private void processMethods() {
            this.parseAllMethodsAsProperties();
            this.processOwnMethods();
        }

        private void processOwnMethods() {
            for (final PsiMethod method : this.psiClass.getPsiClass().getMethods()) {
                RunOnce task = new RunOnce(){

                    @Override
                    public void doRun() {
                        ClassMemberProcessor.this.processOwnMethod(method);
                    }
                };
                MembersCache.this.addTask(method, task);
                PropertyParseResult propertyParseResult = PropertyNameUtils.parseMethodToProperty(method.getName());
                if (propertyParseResult == null) continue;
                MembersCache.this.addTask(propertyParseResult.getPropertyName(), task);
            }
        }

        private void parseAllMethodsAsProperties() {
            for (PsiMethod method : this.psiClass.getPsiClass().getAllMethods()) {
                this.createEmptyEntry(Name.identifier(method.getName()));
                PropertyParseResult propertyParseResult = PropertyNameUtils.parseMethodToProperty(method.getName());
                if (propertyParseResult == null) continue;
                this.createEmptyEntry(Name.identifier(propertyParseResult.getPropertyName()));
            }
        }

        private void processNestedClasses() {
            if (!this.staticMembers) {
                return;
            }
            for (final PsiClass nested : this.psiClass.getPsiClass().getInnerClasses()) {
                MembersCache.this.addTask(nested, new RunOnce(){

                    @Override
                    public void doRun() {
                        ClassMemberProcessor.this.processNestedClass(nested);
                    }
                });
            }
        }

        private boolean includeMember(PsiMemberWrapper member) {
            if (this.psiClass.getPsiClass().isEnum() && this.staticMembers) {
                return member.isStatic();
            }
            if (member.isStatic() != this.staticMembers) {
                return false;
            }
            if (member.getPsiMember().getContainingClass() != this.psiClass.getPsiClass()) {
                return false;
            }
            if (!(!member.isPrivate() || member instanceof PsiMethodWrapper && ((PsiMethodWrapper)member).getJetMethodAnnotation().hasPropertyFlag())) {
                return false;
            }
            return !MembersCache.isObjectMethodInInterface(member.getPsiMember());
        }

        private void processField(PsiField field) {
            PsiFieldWrapper fieldWrapper = new PsiFieldWrapper(field);
            NamedMembers namedMembers = MembersCache.this.getOrCreateEmpty(Name.identifier(fieldWrapper.getName()));
            if (!this.includeMember(fieldWrapper)) {
                return;
            }
            TypeSource type = new TypeSource("", fieldWrapper.getType(), field);
            namedMembers.addPropertyAccessor(new PropertyPsiDataElement(fieldWrapper, type, null));
        }

        private void processOwnMethod(PsiMethod ownMethod) {
            PsiMethodWrapper method = new PsiMethodWrapper(ownMethod);
            if (!this.includeMember(method)) {
                return;
            }
            PropertyParseResult propertyParseResult = PropertyNameUtils.parseMethodToProperty(method.getName());
            if (propertyParseResult != null && propertyParseResult.isGetter()) {
                this.processGetter(ownMethod, method, propertyParseResult);
            } else if (propertyParseResult != null && !propertyParseResult.isGetter()) {
                this.processSetter(method, propertyParseResult);
            }
            if (!method.getJetMethodAnnotation().hasPropertyFlag()) {
                NamedMembers namedMembers = MembersCache.this.getOrCreateEmpty(Name.identifier(method.getName()));
                namedMembers.addMethod(method);
            }
        }

        private void processSetter(PsiMethodWrapper method, PropertyParseResult propertyParseResult) {
            String propertyName = propertyParseResult.getPropertyName();
            NamedMembers members = MembersCache.this.getOrCreateEmpty(Name.identifier(propertyName));
            if (method.getJetMethodAnnotation().hasPropertyFlag()) {
                if (method.getParameters().size() == 0) {
                    throw new IllegalStateException();
                }
                int i = 0;
                TypeSource receiverType = null;
                PsiParameterWrapper p1 = method.getParameter(0);
                if (p1.getJetValueParameter().receiver()) {
                    receiverType = new TypeSource(p1.getJetValueParameter().type(), p1.getPsiParameter().getType(), p1.getPsiParameter());
                    ++i;
                }
                while (i < method.getParameters().size() && method.getParameter(i).getJetTypeParameter().isDefined()) {
                    ++i;
                }
                if (i + 1 != method.getParameters().size()) {
                    throw new IllegalStateException();
                }
                PsiParameterWrapper propertyTypeParameter = method.getParameter(i);
                TypeSource propertyType = new TypeSource(method.getJetMethodAnnotation().propertyType(), propertyTypeParameter.getPsiParameter().getType(), propertyTypeParameter.getPsiParameter());
                members.addPropertyAccessor(new PropertyPsiDataElement(method, false, propertyType, receiverType));
            }
        }

        private void processGetter(PsiMethod ownMethod, PsiMethodWrapper method, PropertyParseResult propertyParseResult) {
            String propertyName = propertyParseResult.getPropertyName();
            NamedMembers members = MembersCache.this.getOrCreateEmpty(Name.identifier(propertyName));
            if (method.getJetMethodAnnotation().hasPropertyFlag()) {
                TypeSource receiverType;
                int i = 0;
                if (i < method.getParameters().size() && method.getParameter(i).getJetValueParameter().receiver()) {
                    PsiParameterWrapper receiverParameter = method.getParameter(i);
                    receiverType = new TypeSource(receiverParameter.getJetValueParameter().type(), receiverParameter.getPsiParameter().getType(), receiverParameter.getPsiParameter());
                    ++i;
                } else {
                    receiverType = null;
                }
                while (i < method.getParameters().size() && method.getParameter(i).getJetTypeParameter().isDefined()) {
                    ++i;
                }
                if (i != method.getParameters().size()) {
                    throw new IllegalStateException("something is wrong with method " + ownMethod);
                }
                PsiType returnType = method.getReturnType();
                assert (returnType != null);
                TypeSource propertyType = new TypeSource(method.getJetMethodAnnotation().propertyType(), returnType, method.getPsiMethod());
                members.addPropertyAccessor(new PropertyPsiDataElement(method, true, propertyType, receiverType));
            }
        }

        private void createEmptyEntry(@NotNull Name identifier) {
            MembersCache.this.getOrCreateEmpty(identifier);
        }

        private void processNestedClass(PsiClass nested) {
            if (MembersCache.isSamInterface(nested)) {
                NamedMembers namedMembers = MembersCache.this.getOrCreateEmpty(Name.identifier(nested.getName()));
                namedMembers.setSamInterface(nested);
            }
        }
    }

    private class ExtraPackageMembersProcessor {
        @NotNull
        private final List<PsiClass> psiClasses;

        private ExtraPackageMembersProcessor(@NotNull List<PsiClass> classes) {
            this.psiClasses = classes;
        }

        private void process() {
            for (PsiClass psiClass : this.psiClasses) {
                if (psiClass instanceof JetJavaMirrorMarker) continue;
                if (JetClassAnnotation.get(psiClass).kind() == 64) {
                    this.processObjectClass(psiClass);
                }
                if (!MembersCache.isSamInterface(psiClass)) continue;
                this.processSamInterface(psiClass);
            }
        }

        private void processObjectClass(@NotNull PsiClass psiClass) {
            PsiField instanceField = psiClass.findFieldByName("instance$", false);
            if (instanceField != null) {
                NamedMembers namedMembers = MembersCache.this.getOrCreateEmpty(Name.identifier(psiClass.getName()));
                TypeSource type = new TypeSource("", instanceField.getType(), instanceField);
                namedMembers.addPropertyAccessor(new PropertyPsiDataElement(new PsiFieldWrapper(instanceField), type, null));
            }
        }

        private void processSamInterface(@NotNull PsiClass psiClass) {
            NamedMembers namedMembers = MembersCache.this.getOrCreateEmpty(Name.identifier(psiClass.getName()));
            namedMembers.setSamInterface(psiClass);
        }
    }
}

