/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReferenceExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.constants.AnnotationValue;
import org.jetbrains.jet.lang.resolve.constants.ArrayValue;
import org.jetbrains.jet.lang.resolve.constants.ByteValue;
import org.jetbrains.jet.lang.resolve.constants.CharValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.DoubleValue;
import org.jetbrains.jet.lang.resolve.constants.EnumValue;
import org.jetbrains.jet.lang.resolve.constants.FloatValue;
import org.jetbrains.jet.lang.resolve.constants.IntValue;
import org.jetbrains.jet.lang.resolve.constants.LongValue;
import org.jetbrains.jet.lang.resolve.constants.NullValue;
import org.jetbrains.jet.lang.resolve.constants.ShortValue;
import org.jetbrains.jet.lang.resolve.constants.StringValue;
import org.jetbrains.jet.lang.resolve.java.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaClassResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.PostponedTasks;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeProjection;

public final class JavaCompileTimeConstResolver {
    private JavaAnnotationResolver annotationResolver;
    private JavaClassResolver classResolver;

    public void setAnnotationResolver(JavaAnnotationResolver annotationResolver) {
        this.annotationResolver = annotationResolver;
    }

    public void setClassResolver(JavaClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    @Nullable
    public CompileTimeConstant<?> getCompileTimeConstFromExpression(FqName annotationFqName, Name parameterName, PsiAnnotationMemberValue value, PostponedTasks postponedTasks) {
        if (value instanceof PsiLiteralExpression) {
            return JavaCompileTimeConstResolver.getCompileTimeConstFromLiteralExpression((PsiLiteralExpression)value);
        }
        if (value instanceof PsiReferenceExpression) {
            return this.getCompileTimeConstFromReferenceExpression((PsiReferenceExpression)value, postponedTasks);
        }
        if (value instanceof PsiArrayInitializerMemberValue) {
            return this.getCompileTimeConstFromArrayExpression(annotationFqName, parameterName, (PsiArrayInitializerMemberValue)value, postponedTasks);
        }
        if (value instanceof PsiAnnotation) {
            return this.getCompileTimeConstFromAnnotation((PsiAnnotation)value, postponedTasks);
        }
        return null;
    }

    @Nullable
    private CompileTimeConstant<?> getCompileTimeConstFromAnnotation(PsiAnnotation value, PostponedTasks taskList) {
        AnnotationDescriptor annotationDescriptor = this.annotationResolver.resolveAnnotation(value, taskList);
        if (annotationDescriptor != null) {
            return new AnnotationValue(annotationDescriptor);
        }
        return null;
    }

    @Nullable
    private CompileTimeConstant<?> getCompileTimeConstFromArrayExpression(FqName annotationFqName, Name valueName, PsiArrayInitializerMemberValue value, PostponedTasks taskList) {
        PsiAnnotationMemberValue[] initializers = value.getInitializers();
        List<CompileTimeConstant<?>> values = this.getCompileTimeConstantForArrayValues(annotationFqName, valueName, taskList, initializers);
        ClassDescriptor classDescriptor = this.classResolver.resolveClass(annotationFqName, DescriptorSearchRule.INCLUDE_KOTLIN, taskList);
        ValueParameterDescriptor valueParameterDescriptor = DescriptorResolverUtils.getValueParameterDescriptorForAnnotationParameter(valueName, classDescriptor);
        if (valueParameterDescriptor == null) {
            return null;
        }
        JetType expectedArrayType = valueParameterDescriptor.getType();
        return new ArrayValue(values, expectedArrayType);
    }

    private List<CompileTimeConstant<?>> getCompileTimeConstantForArrayValues(FqName annotationQualifiedName, Name valueName, PostponedTasks taskList, PsiAnnotationMemberValue[] initializers) {
        ArrayList values = new ArrayList();
        for (PsiAnnotationMemberValue initializer : initializers) {
            NullValue compileTimeConstant = this.getCompileTimeConstFromExpression(annotationQualifiedName, valueName, initializer, taskList);
            if (compileTimeConstant == null) {
                compileTimeConstant = NullValue.NULL;
            }
            values.add(compileTimeConstant);
        }
        return values;
    }

    @Nullable
    private CompileTimeConstant<?> getCompileTimeConstFromReferenceExpression(PsiReferenceExpression value, PostponedTasks taskList) {
        PsiElement psiElement;
        PsiElement resolveElement = value.resolve();
        if (resolveElement instanceof PsiEnumConstant && (psiElement = resolveElement.getParent()) instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)psiElement;
            String fqName = psiClass.getQualifiedName();
            if (fqName == null) {
                return null;
            }
            ClassDescriptor classDescriptor = this.classResolver.resolveClass(new FqName(fqName), DescriptorSearchRule.INCLUDE_KOTLIN, taskList);
            if (classDescriptor == null) {
                return null;
            }
            ClassDescriptor classObjectDescriptor = classDescriptor.getClassObjectDescriptor();
            if (classObjectDescriptor == null) {
                return null;
            }
            JetScope scope = classObjectDescriptor.getMemberScope(Lists.<TypeProjection>newArrayList());
            Name identifier = Name.identifier(((PsiEnumConstant)resolveElement).getName());
            Collection<VariableDescriptor> properties = scope.getProperties(identifier);
            for (VariableDescriptor variableDescriptor : properties) {
                if (variableDescriptor.getReceiverParameter() != null) continue;
                return new EnumValue((PropertyDescriptor)variableDescriptor);
            }
            return null;
        }
        return null;
    }

    @Nullable
    private static CompileTimeConstant<?> getCompileTimeConstFromLiteralExpression(PsiLiteralExpression value) {
        Object literalValue = value.getValue();
        if (literalValue instanceof String) {
            return new StringValue((String)literalValue);
        }
        if (literalValue instanceof Byte) {
            return new ByteValue((Byte)literalValue);
        }
        if (literalValue instanceof Short) {
            return new ShortValue((Short)literalValue);
        }
        if (literalValue instanceof Character) {
            return new CharValue(((Character)literalValue).charValue());
        }
        if (literalValue instanceof Integer) {
            return new IntValue((Integer)literalValue);
        }
        if (literalValue instanceof Long) {
            return new LongValue((Long)literalValue);
        }
        if (literalValue instanceof Float) {
            return new FloatValue(((Float)literalValue).floatValue());
        }
        if (literalValue instanceof Double) {
            return new DoubleValue((Double)literalValue);
        }
        if (literalValue == null) {
            return NullValue.NULL;
        }
        return null;
    }
}

