/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JavaTypeTransformer;
import org.jetbrains.jet.lang.resolve.java.JvmAbi;
import org.jetbrains.jet.lang.resolve.java.TypeUsage;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiParameterWrapper;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public final class JavaValueParameterResolver {
    private JavaTypeTransformer typeTransformer;

    @NotNull
    private JvmMethodParameterMeaning resolveParameterDescriptor(DeclarationDescriptor containingDeclaration, int i, PsiParameterWrapper parameter, TypeVariableResolver typeVariableResolver) {
        JetType varargElementType;
        JetType outType;
        if (parameter.getJetTypeParameter().isDefined()) {
            return JvmMethodParameterMeaning.typeInfo();
        }
        PsiType psiType = parameter.getPsiParameter().getType();
        Name name = Name.identifier(JavaValueParameterResolver.getParameterName(i, parameter));
        if (parameter.getJetValueParameter().name().length() > 0) {
            name = Name.identifier(parameter.getJetValueParameter().name());
        }
        String typeFromAnnotation = parameter.getJetValueParameter().type();
        boolean receiver = parameter.getJetValueParameter().receiver();
        boolean hasDefaultValue = parameter.getJetValueParameter().hasDefaultValue();
        if (typeFromAnnotation.length() > 0) {
            outType = this.getTypeTransformer().transformToType(typeFromAnnotation, typeVariableResolver);
        } else {
            TypeUsage typeUsage = JavaTypeTransformer.adjustTypeUsageWithMutabilityAnnotations(parameter.getPsiParameter(), TypeUsage.MEMBER_SIGNATURE_CONTRAVARIANT);
            outType = this.getTypeTransformer().transformToType(psiType, typeUsage, typeVariableResolver);
        }
        if (psiType instanceof PsiEllipsisType || parameter.getJetValueParameter().vararg()) {
            varargElementType = KotlinBuiltIns.getInstance().getArrayElementType(TypeUtils.makeNotNullable(outType));
            outType = TypeUtils.makeNotNullable(outType);
        } else {
            varargElementType = null;
        }
        if (receiver) {
            return JvmMethodParameterMeaning.receiver(outType);
        }
        JetType transformedType = JavaAnnotationResolver.findAnnotationWithExternal(parameter.getPsiParameter(), JvmAbi.JETBRAINS_NOT_NULL_ANNOTATION.getFqName().asString()) != null ? TypeUtils.makeNullableAsSpecified(outType, false) : outType;
        return JvmMethodParameterMeaning.regular(new ValueParameterDescriptorImpl(containingDeclaration, i, Collections.<AnnotationDescriptor>emptyList(), name, transformedType, hasDefaultValue, varargElementType));
    }

    @NotNull
    private JavaTypeTransformer getTypeTransformer() {
        return this.typeTransformer;
    }

    public void setTypeTransformer(JavaTypeTransformer typeTransformer) {
        this.typeTransformer = typeTransformer;
    }

    @NotNull
    private static String getParameterName(int number, @NotNull PsiParameterWrapper parameter) {
        String psiParameterName = parameter.getPsiParameter().getName();
        return psiParameterName != null ? psiParameterName : "p" + number;
    }

    public JavaDescriptorResolver.ValueParameterDescriptors resolveParameterDescriptors(DeclarationDescriptor containingDeclaration, List<PsiParameterWrapper> parameters, TypeVariableResolver typeVariableResolver) {
        ArrayList<ValueParameterDescriptor> result = new ArrayList<ValueParameterDescriptor>();
        JetType receiverType = null;
        int indexDelta = 0;
        int parametersLength = parameters.size();
        for (int i = 0; i < parametersLength; ++i) {
            PsiParameterWrapper parameter = parameters.get(i);
            JvmMethodParameterMeaning meaning = this.resolveParameterDescriptor(containingDeclaration, i + indexDelta, parameter, typeVariableResolver);
            if (meaning.kind == JvmMethodParameterKind.TYPE_INFO) {
                --indexDelta;
                continue;
            }
            if (meaning.kind == JvmMethodParameterKind.REGULAR) {
                result.add(meaning.valueParameterDescriptor);
                continue;
            }
            if (meaning.kind != JvmMethodParameterKind.RECEIVER) continue;
            if (receiverType != null) {
                throw new IllegalStateException("more than one receiver");
            }
            --indexDelta;
            receiverType = meaning.receiverType;
        }
        return new JavaDescriptorResolver.ValueParameterDescriptors(receiverType, result);
    }

    public static class JvmMethodParameterMeaning {
        public final JvmMethodParameterKind kind;
        private final JetType receiverType;
        private final ValueParameterDescriptor valueParameterDescriptor;

        private JvmMethodParameterMeaning(JvmMethodParameterKind kind, @Nullable JetType receiverType, @Nullable ValueParameterDescriptor valueParameterDescriptor) {
            this.kind = kind;
            this.receiverType = receiverType;
            this.valueParameterDescriptor = valueParameterDescriptor;
        }

        public static JvmMethodParameterMeaning receiver(@NotNull JetType receiverType) {
            return new JvmMethodParameterMeaning(JvmMethodParameterKind.RECEIVER, receiverType, null);
        }

        public static JvmMethodParameterMeaning regular(@NotNull ValueParameterDescriptor valueParameterDescriptor) {
            return new JvmMethodParameterMeaning(JvmMethodParameterKind.REGULAR, null, valueParameterDescriptor);
        }

        public static JvmMethodParameterMeaning typeInfo() {
            return new JvmMethodParameterMeaning(JvmMethodParameterKind.TYPE_INFO, null, null);
        }
    }

    public static enum JvmMethodParameterKind {
        REGULAR,
        RECEIVER,
        TYPE_INFO;

    }
}

