/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.scope;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.java.provider.ClassPsiDeclarationProvider;
import org.jetbrains.jet.lang.resolve.java.provider.NamedMembers;
import org.jetbrains.jet.lang.resolve.java.provider.PackagePsiDeclarationProvider;
import org.jetbrains.jet.lang.resolve.java.provider.PsiDeclarationProvider;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeImpl;

public abstract class JavaBaseScope
extends JetScopeImpl {
    @NotNull
    protected final JavaSemanticServices semanticServices;
    @NotNull
    protected final PsiDeclarationProvider declarationProvider;
    @NotNull
    private final Map<Name, Set<FunctionDescriptor>> functionDescriptors = Maps.newHashMap();
    @NotNull
    private final Map<Name, Set<VariableDescriptor>> propertyDescriptors = Maps.newHashMap();
    @Nullable
    private Collection<DeclarationDescriptor> allDescriptors = null;
    @Nullable
    private Set<ClassDescriptor> objectDescriptors = null;
    @NotNull
    protected final ClassOrNamespaceDescriptor descriptor;
    private Collection<ClassDescriptor> innerClasses = null;

    protected JavaBaseScope(@NotNull ClassOrNamespaceDescriptor descriptor, @NotNull JavaSemanticServices semanticServices, @NotNull PsiDeclarationProvider declarationProvider) {
        this.semanticServices = semanticServices;
        this.declarationProvider = declarationProvider;
        this.descriptor = descriptor;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        return this.descriptor;
    }

    @Override
    @NotNull
    public Collection<VariableDescriptor> getProperties(@NotNull Name name) {
        Set<VariableDescriptor> cached = this.propertyDescriptors.get(name);
        if (cached != null) {
            return cached;
        }
        if (this.allDescriptorsComputed()) {
            return Collections.emptySet();
        }
        Set<VariableDescriptor> computedDescriptors = this.computePropertyDescriptors(name);
        this.propertyDescriptors.put(name, computedDescriptors);
        return computedDescriptors;
    }

    @NotNull
    private Set<VariableDescriptor> computePropertyDescriptors(@NotNull Name name) {
        return this.getResolver().resolveFieldGroupByName(name, this.declarationProvider, this.descriptor);
    }

    @Override
    @NotNull
    public Collection<FunctionDescriptor> getFunctions(@NotNull Name name) {
        Set<FunctionDescriptor> cached = this.functionDescriptors.get(name);
        if (cached != null) {
            return cached;
        }
        if (this.allDescriptorsComputed()) {
            return Collections.emptySet();
        }
        Set<FunctionDescriptor> computedDescriptors = this.computeFunctionDescriptor(name);
        this.functionDescriptors.put(name, computedDescriptors);
        return computedDescriptors;
    }

    @NotNull
    protected abstract Set<FunctionDescriptor> computeFunctionDescriptor(@NotNull Name var1);

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        if (this.allDescriptorsComputed()) {
            return this.allDescriptors;
        }
        this.allDescriptors = this.computeAllDescriptors();
        return this.allDescriptors;
    }

    private boolean allDescriptorsComputed() {
        return this.allDescriptors != null;
    }

    @NotNull
    protected Collection<DeclarationDescriptor> computeAllDescriptors() {
        HashSet<DeclarationDescriptor> result = Sets.newHashSet();
        result.addAll(this.computeFieldAndFunctionDescriptors());
        result.addAll(JavaBaseScope.filterObjects(this.getInnerClasses(), false));
        return result;
    }

    @Override
    @NotNull
    public Set<ClassDescriptor> getObjectDescriptors() {
        if (this.objectDescriptors == null) {
            this.objectDescriptors = new HashSet<ClassDescriptor>(JavaBaseScope.filterObjects(this.getInnerClasses(), true));
        }
        return this.objectDescriptors;
    }

    @NotNull
    protected abstract Collection<ClassDescriptor> computeInnerClasses();

    @NotNull
    private Collection<DeclarationDescriptor> computeFieldAndFunctionDescriptors() {
        ArrayList<DeclarationDescriptor> result = Lists.newArrayList();
        for (NamedMembers members : this.declarationProvider.getMembersCache().allMembers()) {
            Name name = members.getName();
            ProgressIndicatorProvider.checkCanceled();
            result.addAll(this.getFunctions(name));
            ProgressIndicatorProvider.checkCanceled();
            result.addAll(this.getProperties(name));
        }
        return result;
    }

    @NotNull
    protected JavaDescriptorResolver getResolver() {
        return this.semanticServices.getDescriptorResolver();
    }

    @NotNull
    public PsiElement getPsiElement() {
        if (this.declarationProvider instanceof ClassPsiDeclarationProvider) {
            return ((ClassPsiDeclarationProvider)this.declarationProvider).getPsiClass();
        }
        if (this.declarationProvider instanceof PackagePsiDeclarationProvider) {
            return ((PackagePsiDeclarationProvider)this.declarationProvider).getPsiPackage();
        }
        throw new IllegalStateException();
    }

    @NotNull
    protected Collection<ClassDescriptor> getInnerClasses() {
        if (this.innerClasses == null) {
            this.innerClasses = this.computeInnerClasses();
        }
        return this.innerClasses;
    }

    private static <T extends ClassDescriptor> Collection<T> filterObjects(Collection<T> classes, final boolean objects) {
        return ContainerUtil.filter(classes, new Condition<T>(){

            @Override
            public boolean value(T classDescriptor) {
                return classDescriptor.getKind().isObject() == objects;
            }
        });
    }
}

