/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.wrapper;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.TypeSource;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiFieldWrapper;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiMemberWrapper;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiMethodWrapper;

public final class PropertyPsiDataElement {
    @NotNull
    private final PsiMemberWrapper member;
    private final boolean getter;
    @NotNull
    private final TypeSource type;
    @Nullable
    private final TypeSource receiverType;

    public PropertyPsiDataElement(@NotNull PsiMethodWrapper method, boolean getter, @NotNull TypeSource type, @Nullable TypeSource receiverType) {
        this.member = method;
        this.type = type;
        this.receiverType = receiverType;
        this.getter = getter;
    }

    public PropertyPsiDataElement(@NotNull PsiFieldWrapper field, @NotNull TypeSource type, @Nullable TypeSource receiverType) {
        this.member = field;
        this.type = type;
        this.receiverType = receiverType;
        this.getter = false;
    }

    @NotNull
    public PsiMemberWrapper getMember() {
        return this.member;
    }

    @NotNull
    public TypeSource getType() {
        return this.type;
    }

    @Nullable
    public TypeSource getReceiverType() {
        return this.receiverType;
    }

    boolean isExtension() {
        return this.getReceiverType() != null;
    }

    public boolean isGetter() {
        return this.member instanceof PsiMethodWrapper && this.getter;
    }

    public boolean isSetter() {
        return this.member instanceof PsiMethodWrapper && !this.getter;
    }

    public boolean isField() {
        return this.member instanceof PsiFieldWrapper;
    }
}

