/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.wrapper;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.kt.JetConstructorAnnotation;
import org.jetbrains.jet.lang.resolve.java.kt.JetMethodAnnotation;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiMemberWrapper;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiParameterWrapper;

public class PsiMethodWrapper
extends PsiMemberWrapper {
    private List<PsiParameterWrapper> parameters;
    private JetMethodAnnotation jetMethodAnnotation;
    private JetConstructorAnnotation jetConstructorAnnotation;

    public PsiMethodWrapper(@NotNull PsiMethod psiMethod) {
        super(psiMethod);
    }

    @NotNull
    public List<PsiParameterWrapper> getParameters() {
        if (this.parameters == null) {
            PsiParameter[] psiParameters = this.getPsiMethod().getParameterList().getParameters();
            this.parameters = new ArrayList<PsiParameterWrapper>(psiParameters.length);
            for (PsiParameter psiParameter : psiParameters) {
                this.parameters.add(new PsiParameterWrapper(psiParameter));
            }
        }
        return this.parameters;
    }

    @NotNull
    public PsiParameterWrapper getParameter(int i) {
        return this.getParameters().get(i);
    }

    @NotNull
    public JetMethodAnnotation getJetMethodAnnotation() {
        if (this.jetMethodAnnotation == null) {
            this.jetMethodAnnotation = JetMethodAnnotation.get(this.getPsiMethod());
        }
        return this.jetMethodAnnotation;
    }

    @NotNull
    public JetConstructorAnnotation getJetConstructorAnnotation() {
        if (this.jetConstructorAnnotation == null) {
            this.jetConstructorAnnotation = JetConstructorAnnotation.get(this.getPsiMethod());
        }
        return this.jetConstructorAnnotation;
    }

    @Override
    public boolean isAbstract() {
        return this.psiMember.hasModifierProperty("abstract");
    }

    @NotNull
    public PsiMethod getPsiMethod() {
        return (PsiMethod)this.psiMember;
    }

    @Nullable
    public PsiType getReturnType() {
        return this.getPsiMethod().getReturnType();
    }
}

