/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetImportsFactory;
import org.jetbrains.jet.lang.psi.JetNamespaceHeader;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.lazy.LazyImportScope;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.storage.MemoizedFunctionToNotNull;
import org.jetbrains.jet.lang.resolve.lazy.storage.NotNullLazyValue;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.scopes.ChainedScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public class ScopeProvider {
    private final ResolveSession resolveSession;
    private final MemoizedFunctionToNotNull<JetFile, JetScope> fileScopes;
    private final NotNullLazyValue<JetScope> defaultImportsScope;

    public ScopeProvider(@NotNull ResolveSession resolveSession) {
        this.resolveSession = resolveSession;
        this.fileScopes = resolveSession.getStorageManager().createMemoizedFunction(new Function<JetFile, JetScope>(){

            @Override
            public JetScope fun(@NotNull JetFile file) {
                return ScopeProvider.this.createFileScope(file);
            }
        }, StorageManager.ReferenceKind.WEAK);
        this.defaultImportsScope = resolveSession.getStorageManager().createLazyValue(new Computable<JetScope>(){

            @Override
            public JetScope compute() {
                return ScopeProvider.this.createScopeWithDefaultImports();
            }
        });
    }

    @NotNull
    public JetScope getFileScope(JetFile file) {
        return this.fileScopes.fun(file);
    }

    private JetScope createFileScope(JetFile file) {
        NamespaceDescriptor rootPackageDescriptor = this.resolveSession.getPackageDescriptorByFqName(FqName.ROOT);
        if (rootPackageDescriptor == null) {
            throw new IllegalStateException("Root package not found");
        }
        NamespaceDescriptor packageDescriptor = this.getFilePackageDescriptor(file);
        LazyImportScope importsScope = LazyImportScope.createImportScopeForFile(this.resolveSession, packageDescriptor, file, this.resolveSession.getTrace(), "Lazy Imports Scope for file " + file.getName());
        return new ChainedScope((DeclarationDescriptor)packageDescriptor, "File scope: " + file.getName(), packageDescriptor.getMemberScope(), rootPackageDescriptor.getMemberScope(), importsScope, this.defaultImportsScope.compute());
    }

    private JetScope createScopeWithDefaultImports() {
        NamespaceDescriptor rootPackageDescriptor = this.resolveSession.getPackageDescriptorByFqName(FqName.ROOT);
        if (rootPackageDescriptor == null) {
            throw new IllegalStateException("Root package not found");
        }
        JetImportsFactory importsFactory = this.resolveSession.getInjector().getJetImportsFactory();
        List<ImportPath> defaultImports = this.resolveSession.getRootModuleDescriptor().getDefaultImports();
        Collection<JetImportDirective> defaultImportDirectives = importsFactory.createImportDirectives(defaultImports);
        return new LazyImportScope(this.resolveSession, rootPackageDescriptor, Lists.reverse(Lists.newArrayList(defaultImportDirectives)), TemporaryBindingTrace.create(this.resolveSession.getTrace(), "Transient trace for default imports lazy resolve"), "Lazy default imports scope");
    }

    @NotNull
    private NamespaceDescriptor getFilePackageDescriptor(JetFile file) {
        JetNamespaceHeader header = file.getNamespaceHeader();
        if (header == null) {
            throw new IllegalArgumentException("Scripts are not supported: " + file.getName());
        }
        FqName fqName = new FqName(header.getQualifiedName());
        NamespaceDescriptor packageDescriptor = this.resolveSession.getPackageDescriptorByFqName(fqName);
        if (packageDescriptor == null) {
            throw new IllegalStateException("Package not found: " + fqName + " maybe the file is not in scope of this resolve session: " + file.getName());
        }
        return packageDescriptor;
    }

    @NotNull
    public JetScope getResolutionScopeForDeclaration(@NotNull PsiElement elementOfDeclaration) {
        JetDeclaration jetDeclaration = PsiTreeUtil.getParentOfType(elementOfDeclaration, JetDeclaration.class, false);
        assert (!(elementOfDeclaration instanceof JetDeclaration) || jetDeclaration == elementOfDeclaration) : "For JetDeclaration element getParentOfType() should return itself.";
        JetDeclaration parentDeclaration = PsiTreeUtil.getParentOfType((PsiElement)jetDeclaration, JetDeclaration.class);
        if (parentDeclaration == null) {
            return this.getFileScope((JetFile)elementOfDeclaration.getContainingFile());
        }
        assert (jetDeclaration != null) : "Can't happen because of getParentOfType(null, ?) == null";
        if (parentDeclaration instanceof JetClassOrObject) {
            JetClassOrObject classOrObject = (JetClassOrObject)parentDeclaration;
            LazyClassDescriptor classDescriptor = (LazyClassDescriptor)this.resolveSession.getClassDescriptor(classOrObject);
            if (jetDeclaration instanceof JetClassInitializer || jetDeclaration instanceof JetProperty) {
                return classDescriptor.getScopeForPropertyInitializerResolution();
            }
            if (jetDeclaration instanceof JetEnumEntry) {
                LazyClassDescriptor descriptor = (LazyClassDescriptor)classDescriptor.getClassObjectDescriptor();
                assert (descriptor != null) : "There should be class object descriptor for enum class " + parentDeclaration.getText() + " on entry " + jetDeclaration.getText();
                return descriptor.getScopeForMemberDeclarationResolution();
            }
            return classDescriptor.getScopeForMemberDeclarationResolution();
        }
        if (parentDeclaration instanceof JetClassObject) {
            assert (jetDeclaration instanceof JetObjectDeclaration) : "Should be situation for getting scope for object in class [object {...}]";
            JetClassObject classObject = (JetClassObject)parentDeclaration;
            LazyClassDescriptor classObjectDescriptor = (LazyClassDescriptor)this.resolveSession.getClassObjectDescriptor(classObject).getContainingDeclaration();
            return classObjectDescriptor.getScopeForMemberDeclarationResolution();
        }
        throw new IllegalStateException("Don't call this method for local declarations: " + jetDeclaration + " " + jetDeclaration.getText());
    }
}

