/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.descriptors;

import com.intellij.util.Function;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceDescriptorParent;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.AbstractLazyMemberScope;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyPackageDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.storage.MemoizedFunctionToNullable;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public class LazyPackageMemberScope
extends AbstractLazyMemberScope<NamespaceDescriptor, PackageMemberDeclarationProvider> {
    private final MemoizedFunctionToNullable<Name, NamespaceDescriptor> packageDescriptors;

    public LazyPackageMemberScope(@NotNull ResolveSession resolveSession, @NotNull PackageMemberDeclarationProvider declarationProvider, @NotNull NamespaceDescriptor thisPackage) {
        super(resolveSession, declarationProvider, thisPackage);
        this.packageDescriptors = resolveSession.getStorageManager().createMemoizedFunctionWithNullableValues(new Function<Name, NamespaceDescriptor>(){

            @Override
            public NamespaceDescriptor fun(Name name) {
                return LazyPackageMemberScope.this.createPackageDescriptor(name);
            }
        }, StorageManager.ReferenceKind.STRONG);
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        return this.packageDescriptors.fun(name);
    }

    @Nullable
    public NamespaceDescriptor createPackageDescriptor(@NotNull Name name) {
        if (!((PackageMemberDeclarationProvider)this.declarationProvider).isPackageDeclared(name)) {
            return null;
        }
        PackageMemberDeclarationProvider packageMemberDeclarationProvider = this.resolveSession.getDeclarationProviderFactory().getPackageMemberDeclarationProvider(DescriptorUtils.getFQName(this.thisDescriptor).child(name).toSafe());
        assert (packageMemberDeclarationProvider != null) : "Package is declared, but declaration provider is not found: " + name;
        return new LazyPackageDescriptor((NamespaceDescriptorParent)this.thisDescriptor, name, this.resolveSession, packageMemberDeclarationProvider);
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        Name actualName = this.resolveSession.resolveClassifierAlias(DescriptorUtils.getFQName(this.thisDescriptor).toSafe(), name);
        return super.getClassifier(actualName);
    }

    @Override
    @NotNull
    protected JetScope getScopeForMemberDeclarationResolution(JetDeclaration declaration) {
        return this.resolveSession.getInjector().getScopeProvider().getFileScope((JetFile)declaration.getContainingFile());
    }

    @Override
    protected ReceiverParameterDescriptor getImplicitReceiver() {
        return ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER;
    }

    @Override
    protected void getNonDeclaredFunctions(@NotNull Name name, @NotNull Set<FunctionDescriptor> result) {
    }

    @Override
    protected void getNonDeclaredProperties(@NotNull Name name, @NotNull Set<VariableDescriptor> result) {
    }

    @Override
    protected void addExtraDescriptors(@NotNull Collection<DeclarationDescriptor> result) {
        for (FqName packageFqName : ((PackageMemberDeclarationProvider)this.declarationProvider).getAllDeclaredPackages()) {
            result.add(this.getNamespace(packageFqName.shortName()));
        }
    }

    @Override
    public String toString() {
        return "lazy scope for package " + ((NamespaceDescriptor)this.thisDescriptor).getName();
    }
}

