/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;

public final class JetScopeUtils {
    private JetScopeUtils() {
    }

    public static List<ReceiverValue> getImplicitReceiversHierarchyValues(@NotNull JetScope scope) {
        List<ReceiverParameterDescriptor> hierarchy = scope.getImplicitReceiversHierarchy();
        return Lists.newArrayList(Collections2.transform(hierarchy, new Function<ReceiverParameterDescriptor, ReceiverValue>(){

            @Override
            public ReceiverValue apply(ReceiverParameterDescriptor receiverParameterDescriptor) {
                return receiverParameterDescriptor.getValue();
            }
        }));
    }

    public static Collection<CallableDescriptor> getAllExtensions(@NotNull JetScope scope) {
        HashSet<CallableDescriptor> result = Sets.newHashSet();
        for (DeclarationDescriptor descriptor : scope.getAllDescriptors()) {
            CallableDescriptor callDescriptor;
            if (!(descriptor instanceof CallableDescriptor) || (callDescriptor = (CallableDescriptor)descriptor).getReceiverParameter() == null) continue;
            result.add(callDescriptor);
        }
        return result;
    }

    public static JetScope makeScopeForPropertyAccessor(@NotNull PropertyDescriptor propertyDescriptor, @NotNull JetScope parentScope, @NotNull DescriptorResolver descriptorResolver, @NotNull BindingTrace trace) {
        JetScope propertyDeclarationInnerScope = descriptorResolver.getPropertyDeclarationInnerScope(propertyDescriptor, parentScope, propertyDescriptor.getTypeParameters(), propertyDescriptor.getReceiverParameter(), trace);
        WritableScopeImpl accessorScope = new WritableScopeImpl(propertyDeclarationInnerScope, parentScope.getContainingDeclaration(), new TraceBasedRedeclarationHandler(trace), "Accessor Scope");
        accessorScope.changeLockLevel(WritableScope.LockLevel.READING);
        return accessorScope;
    }
}

