/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.context;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.k2js.translate.utils.JsAstUtils;

public class TemporaryVariable {
    @Nullable
    private final JsExpression assignmentExpression;
    @NotNull
    private final JsName variableName;

    static TemporaryVariable create(@NotNull JsName temporaryName, @Nullable JsExpression initExpression) {
        return new TemporaryVariable(temporaryName, initExpression == null ? null : JsAstUtils.assignment(temporaryName.makeRef(), initExpression));
    }

    protected TemporaryVariable(@NotNull JsName temporaryName, @Nullable JsExpression assignmentExpression) {
        this.variableName = temporaryName;
        this.assignmentExpression = assignmentExpression;
    }

    @NotNull
    public JsNameRef reference() {
        return this.variableName.makeRef();
    }

    @NotNull
    public JsName name() {
        return this.variableName;
    }

    @NotNull
    public JsExpression assignmentExpression() {
        assert (this.assignmentExpression != null);
        return this.assignmentExpression;
    }
}

