/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.functions.factories;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.k2js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.DescriptorPredicate;

public abstract class CompositeFIF
implements FunctionIntrinsicFactory {
    @NotNull
    final Map<DescriptorPredicate, FunctionIntrinsic> patternToIntrinsic = Maps.newHashMap();

    protected CompositeFIF() {
    }

    @Override
    @NotNull
    public Predicate<FunctionDescriptor> getPredicate() {
        Set<DescriptorPredicate> patterns = this.patternToIntrinsic.keySet();
        final DescriptorPredicate[] patterns1 = patterns.toArray(new DescriptorPredicate[patterns.size()]);
        return new DescriptorPredicate(){

            @Override
            public boolean apply(@Nullable FunctionDescriptor descriptor) {
                return Predicates.or(patterns1).apply(descriptor);
            }
        };
    }

    @Override
    @NotNull
    public FunctionIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor) {
        for (DescriptorPredicate pattern : this.patternToIntrinsic.keySet()) {
            if (!pattern.apply(descriptor)) continue;
            return this.patternToIntrinsic.get(pattern);
        }
        throw new IllegalStateException("Must have intrinsic for pattern.");
    }

    protected void add(@NotNull DescriptorPredicate pattern, @NotNull FunctionIntrinsic intrinsic) {
        this.patternToIntrinsic.put(pattern, intrinsic);
    }
}

