/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.functions.factories;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.dart.compiler.backend.js.ast.HasArguments;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNew;
import com.google.dart.compiler.util.AstUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.DescriptorPredicate;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.NamePredicate;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.PatternBuilder;
import org.jetbrains.k2js.translate.operation.OperatorTable;
import org.jetbrains.k2js.translate.utils.JsAstUtils;

public final class PrimitiveBinaryOperationFIF
extends Enum<PrimitiveBinaryOperationFIF>
implements FunctionIntrinsicFactory {
    public static final /* enum */ PrimitiveBinaryOperationFIF INSTANCE = new PrimitiveBinaryOperationFIF();
    @NotNull
    private static final FunctionIntrinsic RANGE_TO_INTRINSIC;
    @NotNull
    private static final FunctionIntrinsic INTEGER_DIVISION_INTRINSIC;
    @NotNull
    private static final NamePredicate BINARY_OPERATIONS;
    private static final DescriptorPredicate INT_WITH_BIT_OPERATIONS;
    private static final ImmutableMap<String, JsBinaryOperator> BINARY_BITWISE_OPERATIONS;
    private static final /* synthetic */ PrimitiveBinaryOperationFIF[] $VALUES;

    public static PrimitiveBinaryOperationFIF[] values() {
        return (PrimitiveBinaryOperationFIF[])$VALUES.clone();
    }

    public static PrimitiveBinaryOperationFIF valueOf(String name) {
        return Enum.valueOf(PrimitiveBinaryOperationFIF.class, name);
    }

    @Override
    @NotNull
    public Predicate<FunctionDescriptor> getPredicate() {
        return Predicates.or(INT_WITH_BIT_OPERATIONS, PatternBuilder.pattern(NamePredicate.PRIMITIVE_NUMBERS, BINARY_OPERATIONS), PatternBuilder.pattern("Boolean.or|and|xor"), PatternBuilder.pattern("String.plus"));
    }

    @Override
    @NotNull
    public FunctionIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor) {
        JsBinaryOperator op;
        if (PatternBuilder.pattern("Int|Byte|Short.div").apply(descriptor)) {
            return INTEGER_DIVISION_INTRINSIC;
        }
        if (descriptor.getName().equals(Name.identifier("rangeTo"))) {
            return RANGE_TO_INTRINSIC;
        }
        if (INT_WITH_BIT_OPERATIONS.apply(descriptor) && (op = BINARY_BITWISE_OPERATIONS.get(descriptor.getName().asString())) != null) {
            return new PrimitiveBinaryOperationFunctionIntrinsic(op);
        }
        JsBinaryOperator operator = PrimitiveBinaryOperationFIF.getOperator(descriptor);
        return new PrimitiveBinaryOperationFunctionIntrinsic(operator);
    }

    @NotNull
    private static JsBinaryOperator getOperator(@NotNull FunctionDescriptor descriptor) {
        JetToken token = OperatorConventions.BINARY_OPERATION_NAMES.inverse().get(descriptor.getName());
        if (token == null) {
            token = OperatorConventions.BOOLEAN_OPERATIONS.inverse().get(descriptor.getName());
        }
        if (token == null) {
            assert (descriptor.getName().asString().equals("xor"));
            return JsBinaryOperator.BIT_XOR;
        }
        return OperatorTable.getBinaryOperator(token);
    }

    static {
        $VALUES = new PrimitiveBinaryOperationFIF[]{INSTANCE};
        RANGE_TO_INTRINSIC = new FunctionIntrinsic(){

            @Override
            @NotNull
            public JsExpression apply(@Nullable JsExpression rangeStart, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
                assert (arguments.size() == 1) : "RangeTo must have one argument.";
                assert (rangeStart != null);
                JsExpression rangeEnd = arguments.get(0);
                JsNameRef expr = AstUtil.newQualifiedNameRef("Kotlin.NumberRange");
                HasArguments numberRangeConstructorInvocation = (HasArguments)((Object)(context.isEcma5() ? new JsInvocation(expr) : new JsNew(expr)));
                JsAstUtils.setArguments(numberRangeConstructorInvocation, rangeStart, rangeEnd);
                return numberRangeConstructorInvocation;
            }
        };
        INTEGER_DIVISION_INTRINSIC = new FunctionIntrinsic(){

            @Override
            @NotNull
            public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
                assert (receiver != null);
                TemporaryVariable left = context.declareTemporary(receiver);
                assert (arguments.size() == 1);
                TemporaryVariable right = context.declareTemporary(arguments.get(0));
                JsBinaryOperation divRes = new JsBinaryOperation(JsBinaryOperator.DIV, left.reference(), right.reference());
                JsBinaryOperation modRes = new JsBinaryOperation(JsBinaryOperator.MOD, left.reference(), right.reference());
                JsBinaryOperation fractionalPart = new JsBinaryOperation(JsBinaryOperator.DIV, modRes, right.reference());
                return AstUtil.newSequence(left.assignmentExpression(), right.assignmentExpression(), JsAstUtils.subtract(divRes, fractionalPart));
            }
        };
        BINARY_OPERATIONS = new NamePredicate(OperatorConventions.BINARY_OPERATION_NAMES.values());
        INT_WITH_BIT_OPERATIONS = PatternBuilder.pattern("Int.or|and|xor|shl|shr|ushr");
        BINARY_BITWISE_OPERATIONS = ImmutableMap.builder().put("or", JsBinaryOperator.BIT_OR).put("and", JsBinaryOperator.BIT_AND).put("xor", JsBinaryOperator.BIT_XOR).put("shl", JsBinaryOperator.SHL).put("shr", JsBinaryOperator.SHR).put("ushr", JsBinaryOperator.SHRU).build();
    }

    private static class PrimitiveBinaryOperationFunctionIntrinsic
    extends FunctionIntrinsic {
        @NotNull
        private final JsBinaryOperator operator;

        private PrimitiveBinaryOperationFunctionIntrinsic(@NotNull JsBinaryOperator operator) {
            this.operator = operator;
        }

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
            assert (receiver != null);
            assert (arguments.size() == 1) : "Binary operator should have a receiver and one argument";
            return new JsBinaryOperation(this.operator, receiver, arguments.get(0));
        }
    }
}

