/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.operation;

import com.google.common.collect.Lists;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.intrinsic.operation.BinaryOperationIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.operation.CompareToInstrinsic;
import org.jetbrains.k2js.translate.intrinsic.operation.EqualsIntrinsic;

public final class BinaryOperationIntrinsics {
    @NotNull
    private final List<BinaryOperationIntrinsic> intrinsics = Lists.newArrayList();

    public BinaryOperationIntrinsics() {
        this.intrinsics.add(new EqualsIntrinsic());
        this.intrinsics.add(new CompareToInstrinsic());
    }

    @Nullable
    public BinaryOperationIntrinsic getIntrinsic(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        for (BinaryOperationIntrinsic intrinsic : this.intrinsics) {
            if (!intrinsic.isApplicable(expression, context)) continue;
            return intrinsic;
        }
        return null;
    }
}

