/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.operation;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.operation.AssignmentTranslator;
import org.jetbrains.k2js.translate.operation.OperatorTable;
import org.jetbrains.k2js.translate.reference.ReferenceAccessTranslator;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public final class IntrinsicAssignmentTranslator
extends AssignmentTranslator {
    @NotNull
    public static JsExpression doTranslate(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        return new IntrinsicAssignmentTranslator(expression, context).translate();
    }

    private IntrinsicAssignmentTranslator(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        super(expression, context);
    }

    @NotNull
    private JsExpression translate() {
        if (PsiUtils.isAssignment(PsiUtils.getOperationToken(this.expression))) {
            return this.translateAsPlainAssignment();
        }
        return this.translateAsAssignmentOperation();
    }

    @NotNull
    private JsExpression translateAsAssignmentOperation() {
        if (this.accessTranslator instanceof ReferenceAccessTranslator) {
            return this.translateAsPlainAssignmentOperation();
        }
        return this.translateAsAssignToCounterpart();
    }

    @NotNull
    private JsExpression translateAsAssignToCounterpart() {
        JsBinaryOperator operator = this.getCounterpartOperator();
        JsBinaryOperation counterpartOperation = new JsBinaryOperation(operator, this.accessTranslator.translateAsGet(), this.right);
        return this.accessTranslator.translateAsSet(counterpartOperation);
    }

    @NotNull
    private JsBinaryOperator getCounterpartOperator() {
        JetToken assignmentOperationToken = PsiUtils.getOperationToken(this.expression);
        assert (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(assignmentOperationToken));
        JetToken counterpartToken = OperatorConventions.ASSIGNMENT_OPERATION_COUNTERPARTS.get(assignmentOperationToken);
        assert (OperatorTable.hasCorrespondingBinaryOperator(counterpartToken)) : "Unsupported token encountered: " + counterpartToken.toString();
        return OperatorTable.getBinaryOperator(counterpartToken);
    }

    @NotNull
    private JsExpression translateAsPlainAssignmentOperation() {
        JsBinaryOperator operator = this.getAssignmentOperator();
        return new JsBinaryOperation(operator, this.accessTranslator.translateAsGet(), this.right);
    }

    @NotNull
    private JsBinaryOperator getAssignmentOperator() {
        JetToken token = PsiUtils.getOperationToken(this.expression);
        assert (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(token));
        assert (OperatorTable.hasCorrespondingBinaryOperator(token)) : "Unsupported token encountered: " + token.toString();
        return OperatorTable.getBinaryOperator(token);
    }

    @NotNull
    private JsExpression translateAsPlainAssignment() {
        return this.accessTranslator.translateAsSet(this.right);
    }
}

