/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.operation;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import com.google.dart.compiler.backend.js.ast.JsPostfixOperation;
import com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.operation.IncrementTranslator;
import org.jetbrains.k2js.translate.operation.OperatorTable;
import org.jetbrains.k2js.translate.reference.ReferenceAccessTranslator;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public final class IntrinsicIncrementTranslator
extends IncrementTranslator {
    @NotNull
    public static JsExpression doTranslate(@NotNull JetUnaryExpression expression, @NotNull TranslationContext context) {
        return new IntrinsicIncrementTranslator(expression, context).translate();
    }

    private IntrinsicIncrementTranslator(@NotNull JetUnaryExpression expression, @NotNull TranslationContext context) {
        super(expression, context);
    }

    @NotNull
    private JsExpression translate() {
        if (this.isPrimitiveExpressionIncrement()) {
            return this.primitiveExpressionIncrement();
        }
        return this.translateIncrementExpression();
    }

    private boolean isPrimitiveExpressionIncrement() {
        return this.accessTranslator instanceof ReferenceAccessTranslator;
    }

    @NotNull
    private JsExpression primitiveExpressionIncrement() {
        JsUnaryOperator operator = OperatorTable.getUnaryOperator(PsiUtils.getOperationToken(this.expression));
        JsExpression getExpression = this.accessTranslator.translateAsGet();
        if (PsiUtils.isPrefix(this.expression)) {
            return new JsPrefixOperation(operator, getExpression);
        }
        return new JsPostfixOperation(operator, getExpression);
    }

    @Override
    @NotNull
    protected JsExpression operationExpression(@NotNull JsExpression receiver) {
        return this.unaryAsBinary(receiver);
    }

    @NotNull
    private JsBinaryOperation unaryAsBinary(@NotNull JsExpression leftExpression) {
        JsNumberLiteral oneLiteral = this.program().getNumberLiteral(1);
        JetToken token = PsiUtils.getOperationToken(this.expression);
        if (token.equals(JetTokens.PLUSPLUS)) {
            return new JsBinaryOperation(JsBinaryOperator.ADD, leftExpression, oneLiteral);
        }
        if (token.equals(JetTokens.MINUSMINUS)) {
            return new JsBinaryOperation(JsBinaryOperator.SUB, leftExpression, oneLiteral);
        }
        throw new AssertionError((Object)"This method should be called only for increment and decrement operators");
    }
}

