/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.operation;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.operation.AssignmentTranslator;
import org.jetbrains.k2js.translate.reference.CallBuilder;
import org.jetbrains.k2js.translate.utils.BindingUtils;

public final class OverloadedAssignmentTranslator
extends AssignmentTranslator {
    @NotNull
    private final FunctionDescriptor operationDescriptor;

    @NotNull
    public static JsExpression doTranslate(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        return new OverloadedAssignmentTranslator(expression, context).translate();
    }

    private OverloadedAssignmentTranslator(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        super(expression, context);
        FunctionDescriptor functionDescriptor = BindingUtils.getFunctionDescriptorForOperationExpression(context.bindingContext(), expression);
        assert (functionDescriptor != null) : "";
        this.operationDescriptor = functionDescriptor;
    }

    @NotNull
    private JsExpression translate() {
        if (this.isVariableReassignment) {
            return this.reassignment();
        }
        return this.overloadedMethodInvocation();
    }

    @NotNull
    private JsExpression reassignment() {
        return this.accessTranslator.translateAsSet(this.overloadedMethodInvocation());
    }

    @NotNull
    private JsExpression overloadedMethodInvocation() {
        return CallBuilder.build(this.context()).descriptor(this.operationDescriptor).receiver(this.accessTranslator.translateAsGet()).args(this.right).translate();
    }
}

