/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.LifecycleStrategy;

public class DecoratingComponentAdapter
implements Serializable,
ComponentAdapter,
LifecycleStrategy {
    private ComponentAdapter delegate;

    public DecoratingComponentAdapter(ComponentAdapter delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object getComponentKey() {
        return this.delegate.getComponentKey();
    }

    @Override
    public Class getComponentImplementation() {
        return this.delegate.getComponentImplementation();
    }

    @Override
    public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException {
        return this.delegate.getComponentInstance(container);
    }

    @Override
    public boolean hasLifecycle(Class type) {
        if (this.delegate instanceof LifecycleStrategy) {
            return ((LifecycleStrategy)((Object)this.delegate)).hasLifecycle(type);
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(this.getPrintableClassName());
        buffer.append(" delegate=");
        buffer.append(this.delegate);
        buffer.append("]");
        return buffer.toString();
    }

    private String getPrintableClassName() {
        String name = this.getClass().getName();
        if ((name = name.substring(name.lastIndexOf(46) + 1)).endsWith("ComponentAdapter")) {
            name = new StringBuffer().append(name.substring(0, name.length() - "ComponentAdapter".length())).append("CA").toString();
        }
        return name;
    }
}

