/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStrongWhitespaceHolderElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeUtil {
    public static final Key<String> UNCLOSED_ELEMENT_PROPERTY = Key.create("UNCLOSED_ELEMENT_PROPERTY");
    public static Key<FileElement> CONTAINING_FILE_KEY_AFTER_REPARSE = Key.create("CONTAINING_FILE_KEY_AFTER_REPARSE");

    private TreeUtil() {
    }

    public static void ensureParsed(ASTNode node) {
        if (node != null) {
            node.getFirstChildNode();
        }
    }

    public static void ensureParsedRecursively(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/TreeUtil", "ensureParsedRecursively"));
        }
        ((TreeElement)node).acceptTree(new RecursiveTreeElementWalkingVisitor(){});
    }

    public static void ensureParsedRecursivelyCheckingProgress(@NotNull ASTNode node, final @NotNull ProgressIndicator indicator) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/TreeUtil", "ensureParsedRecursivelyCheckingProgress"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/psi/impl/source/tree/TreeUtil", "ensureParsedRecursivelyCheckingProgress"));
        }
        ((TreeElement)node).acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            public void visitLeaf(LeafElement leaf) {
                indicator.checkCanceled();
            }
        });
    }

    public static boolean isCollapsedChameleon(ASTNode node) {
        return node instanceof LazyParseableElement && !((LazyParseableElement)node).isParsed();
    }

    @Nullable
    public static ASTNode findChildBackward(ASTNode parent, IElementType type2) {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        for (ASTNode element = parent.getLastChildNode(); element != null; element = element.getTreePrev()) {
            if (element.getElementType() != type2) continue;
            return element;
        }
        return null;
    }

    @Nullable
    public static ASTNode skipElements(ASTNode element, TokenSet types) {
        while (true) {
            if (element == null) {
                return null;
            }
            if (!types.contains(element.getElementType())) break;
            element = element.getTreeNext();
        }
        return element;
    }

    @Nullable
    public static ASTNode skipElementsBack(@Nullable ASTNode element, TokenSet types) {
        if (element == null) {
            return null;
        }
        if (!types.contains(element.getElementType())) {
            return element;
        }
        ASTNode parent = element.getTreeParent();
        ASTNode prev = element;
        while (prev instanceof CompositeElement) {
            if (!types.contains(prev.getElementType())) {
                return prev;
            }
            prev = prev.getTreePrev();
        }
        if (prev == null) {
            return null;
        }
        ASTNode lastRelevant = null;
        for (ASTNode firstChildNode = parent.getFirstChildNode(); firstChildNode != prev; firstChildNode = firstChildNode.getTreeNext()) {
            if (types.contains(firstChildNode.getElementType())) continue;
            lastRelevant = firstChildNode;
        }
        return lastRelevant;
    }

    @Nullable
    public static ASTNode findParent(ASTNode element, IElementType type2) {
        for (ASTNode parent = element.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            if (parent.getElementType() != type2) continue;
            return parent;
        }
        return null;
    }

    @Nullable
    public static ASTNode findParent(ASTNode element, TokenSet types) {
        for (ASTNode parent = element.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            if (!types.contains(parent.getElementType())) continue;
            return parent;
        }
        return null;
    }

    @Nullable
    public static LeafElement findFirstLeaf(ASTNode element) {
        return (LeafElement)TreeUtil.findFirstLeaf(element, true);
    }

    public static ASTNode findFirstLeaf(ASTNode element, boolean expandChameleons) {
        if (element instanceof LeafElement || !expandChameleons && TreeUtil.isCollapsedChameleon(element)) {
            return element;
        }
        for (ASTNode child = element.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            ASTNode leaf = TreeUtil.findFirstLeaf(child, expandChameleons);
            if (leaf == null) continue;
            return leaf;
        }
        return null;
    }

    public static boolean isLeafOrCollapsedChameleon(ASTNode node) {
        return node instanceof LeafElement || TreeUtil.isCollapsedChameleon(node);
    }

    @Nullable
    public static TreeElement findFirstLeafOrChameleon(TreeElement element) {
        if (element == null) {
            return null;
        }
        final Ref<Object> result2 = Ref.create(null);
        element.acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            protected void visitNode(TreeElement element) {
                if (TreeUtil.isLeafOrCollapsedChameleon(element)) {
                    result2.set(element);
                    this.stopWalking();
                    return;
                }
                super.visitNode(element);
            }
        });
        return result2.get();
    }

    @Nullable
    public static ASTNode findLastLeaf(ASTNode element) {
        return TreeUtil.findLastLeaf(element, true);
    }

    public static ASTNode findLastLeaf(ASTNode element, boolean expandChameleons) {
        if (element instanceof LeafElement || !expandChameleons && TreeUtil.isCollapsedChameleon(element)) {
            return element;
        }
        for (ASTNode child = element.getLastChildNode(); child != null; child = child.getTreePrev()) {
            ASTNode leaf = TreeUtil.findLastLeaf(child);
            if (leaf == null) continue;
            return leaf;
        }
        return null;
    }

    @Nullable
    public static ASTNode findSibling(ASTNode start, IElementType elementType) {
        ASTNode child = start;
        while (child != null) {
            if (child.getElementType() == elementType) {
                return child;
            }
            child = child.getTreeNext();
        }
        return null;
    }

    @Nullable
    public static ASTNode findSibling(ASTNode start, TokenSet types) {
        ASTNode child = start;
        while (child != null) {
            if (types.contains(child.getElementType())) {
                return child;
            }
            child = child.getTreeNext();
        }
        return null;
    }

    @Nullable
    public static ASTNode findSiblingBackward(ASTNode start, IElementType elementType) {
        ASTNode child = start;
        while (child != null) {
            if (child.getElementType() == elementType) {
                return child;
            }
            child = child.getTreePrev();
        }
        return null;
    }

    @Nullable
    public static ASTNode findSiblingBackward(ASTNode start, TokenSet types) {
        ASTNode child = start;
        while (child != null) {
            if (types.contains(child.getElementType())) {
                return child;
            }
            child = child.getTreePrev();
        }
        return null;
    }

    @Nullable
    public static ASTNode findCommonParent(ASTNode one, ASTNode two) {
        if (one == two) {
            return one;
        }
        HashSet<ASTNode> parents2 = new HashSet<ASTNode>(20);
        while (one != null) {
            parents2.add(one);
            one = one.getTreeParent();
        }
        while (two != null) {
            if (parents2.contains(two)) {
                return two;
            }
            two = two.getTreeParent();
        }
        return null;
    }

    public static Couple<ASTNode> findTopmostSiblingParents(ASTNode one, ASTNode two) {
        if (one == two) {
            return Couple.of(null, null);
        }
        LinkedList<ASTNode> oneParents = new LinkedList<ASTNode>();
        LinkedList<ASTNode> twoParents = new LinkedList<ASTNode>();
        while (one != null) {
            oneParents.add(one);
            one = one.getTreeParent();
        }
        while (two != null) {
            twoParents.add(two);
            two = two.getTreeParent();
        }
        while ((one = (ASTNode)oneParents.pollLast()) == (two = (ASTNode)twoParents.pollLast()) && one != null) {
        }
        return Couple.of(one, two);
    }

    public static void clearCaches(@NotNull TreeElement tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/tree/TreeUtil", "clearCaches"));
        }
        tree.acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            protected void visitNode(TreeElement element) {
                element.clearCaches();
                super.visitNode(element);
            }
        });
    }

    @Nullable
    public static ASTNode nextLeaf(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/TreeUtil", "nextLeaf"));
        }
        return TreeUtil.nextLeaf((TreeElement)node, null);
    }

    public static FileElement getFileElement(TreeElement element) {
        TreeElement parent;
        for (parent = element; parent != null && !(parent instanceof FileElement); parent = parent.getTreeParent()) {
        }
        if (parent == null) {
            parent = element.getUserData(CONTAINING_FILE_KEY_AFTER_REPARSE);
        }
        return (FileElement)parent;
    }

    @Nullable
    public static ASTNode prevLeaf(ASTNode node) {
        return TreeUtil.prevLeaf((TreeElement)node, null);
    }

    public static boolean isStrongWhitespaceHolder(IElementType type2) {
        return type2 instanceof IStrongWhitespaceHolderElementType;
    }

    public static String getTokenText(Lexer lexer) {
        return ((Object)lexer.getBufferSequence().subSequence(lexer.getTokenStart(), lexer.getTokenEnd())).toString();
    }

    @Nullable
    public static LeafElement nextLeaf(@NotNull TreeElement start, CommonParentState commonParent) {
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/psi/impl/source/tree/TreeUtil", "nextLeaf"));
        }
        return (LeafElement)TreeUtil.nextLeaf(start, commonParent, null, true);
    }

    @Nullable
    public static TreeElement nextLeaf(@NotNull TreeElement start, CommonParentState commonParent, IElementType searchedType, boolean expandChameleons) {
        TreeElement element;
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/psi/impl/source/tree/TreeUtil", "nextLeaf"));
        }
        for (element = start; element != null; element = element.getTreeParent()) {
            if (commonParent != null) {
                commonParent.startLeafBranchStart = element;
                TreeUtil.initStrongWhitespaceHolder(commonParent, element, true);
            }
            TreeElement nextTree = element;
            TreeElement next = null;
            while (next == null && (nextTree = nextTree.getTreeNext()) != null) {
                if (nextTree.getElementType() == searchedType) {
                    return nextTree;
                }
                next = TreeUtil.findFirstLeafOrType(nextTree, searchedType, commonParent, expandChameleons);
            }
            if (next == null) continue;
            if (commonParent != null) {
                commonParent.nextLeafBranchStart = nextTree;
            }
            return next;
        }
        return element;
    }

    private static void initStrongWhitespaceHolder(CommonParentState commonParent, ASTNode start, boolean slopeSide) {
        if (start instanceof CompositeElement && (TreeUtil.isStrongWhitespaceHolder(start.getElementType()) || slopeSide && start.getUserData(UNCLOSED_ELEMENT_PROPERTY) != null)) {
            commonParent.strongWhiteSpaceHolder = (CompositeElement)start;
            commonParent.isStrongElementOnRisingSlope = slopeSide;
        }
    }

    @Nullable
    private static TreeElement findFirstLeafOrType(@NotNull TreeElement element, final IElementType searchedType, final CommonParentState commonParent, final boolean expandChameleons) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/TreeUtil", "findFirstLeafOrType"));
        }
        class MyVisitor
        extends RecursiveTreeElementWalkingVisitor {
            TreeElement result;

            MyVisitor(boolean doTransform) {
                super(doTransform);
            }

            @Override
            protected void visitNode(TreeElement node) {
                if (this.result != null) {
                    return;
                }
                if (commonParent != null) {
                    TreeUtil.initStrongWhitespaceHolder(commonParent, node, false);
                }
                if (!expandChameleons && TreeUtil.isCollapsedChameleon(node) || node instanceof LeafElement || node.getElementType() == searchedType) {
                    this.result = node;
                    return;
                }
                super.visitNode(node);
            }
        }
        MyVisitor visitor = new MyVisitor(expandChameleons);
        element.acceptTree(visitor);
        return visitor.result;
    }

    @Nullable
    public static ASTNode prevLeaf(TreeElement start, @Nullable CommonParentState commonParent) {
        while (start != null) {
            if (commonParent != null) {
                if (commonParent.strongWhiteSpaceHolder != null && start.getUserData(UNCLOSED_ELEMENT_PROPERTY) != null) {
                    commonParent.strongWhiteSpaceHolder = (CompositeElement)start;
                }
                commonParent.nextLeafBranchStart = start;
            }
            ASTNode prevTree = start;
            ASTNode prev = null;
            while (prev == null && (prevTree = prevTree.getTreePrev()) != null) {
                prev = TreeUtil.findLastLeaf(prevTree);
            }
            if (prev != null) {
                if (commonParent != null) {
                    commonParent.startLeafBranchStart = prevTree;
                }
                return prev;
            }
            start = start.getTreeParent();
        }
        return null;
    }

    @Nullable
    public static ASTNode nextLeaf(@Nullable ASTNode start, boolean expandChameleons) {
        while (start != null) {
            for (ASTNode each = start.getTreeNext(); each != null; each = each.getTreeNext()) {
                ASTNode leaf = TreeUtil.findFirstLeaf(each, expandChameleons);
                if (leaf == null) continue;
                return leaf;
            }
            start = start.getTreeParent();
        }
        return null;
    }

    @Nullable
    public static ASTNode prevLeaf(@Nullable ASTNode start, boolean expandChameleons) {
        while (start != null) {
            for (ASTNode each = start.getTreePrev(); each != null; each = each.getTreePrev()) {
                ASTNode leaf = TreeUtil.findLastLeaf(each, expandChameleons);
                if (leaf == null) continue;
                return leaf;
            }
            start = start.getTreeParent();
        }
        return null;
    }

    @Nullable
    public static ASTNode getLastChild(ASTNode element) {
        ASTNode child = element;
        while (child != null) {
            element = child;
            child = element.getLastChildNode();
        }
        return element;
    }

    public static void bindStubsToTree(@NotNull PsiFileImpl file, @NotNull StubTree stubTree) throws StubBindingException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/tree/TreeUtil", "bindStubsToTree"));
        }
        if (stubTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubTree", "com/intellij/psi/impl/source/tree/TreeUtil", "bindStubsToTree"));
        }
        final Iterator stubs = stubTree.getPlainList().iterator();
        stubs.next();
        FileElement tree = file.getTreeElement();
        assert (tree != null) : file;
        IStubFileElementType type2 = file.getElementTypeForStubBuilder();
        assert (type2 != null);
        final StubBuilder builder = type2.getBuilder();
        tree.acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            protected void visitNode(TreeElement node) {
                CompositeElement parent = node.getTreeParent();
                if (parent != null && builder.skipChildProcessingWhenBuildingStubs(parent, node)) {
                    return;
                }
                IElementType type2 = node.getElementType();
                if (type2 instanceof IStubElementType && ((IStubElementType)type2).shouldCreateStub(node)) {
                    StubElement stub;
                    StubElement stubElement = stub = stubs.hasNext() ? (StubElement)stubs.next() : null;
                    if (stub == null || stub.getStubType() != type2) {
                        throw new StubBindingException("stub:" + stub + ", AST:" + type2);
                    }
                    ((StubBase)stub).setPsi(node.getPsi());
                }
                super.visitNode(node);
            }
        });
    }

    public static class StubBindingException
    extends RuntimeException {
        public StubBindingException(String message) {
            super(message);
        }
    }

    public static final class CommonParentState {
        public TreeElement startLeafBranchStart = null;
        public ASTNode nextLeafBranchStart = null;
        public CompositeElement strongWhiteSpaceHolder = null;
        public boolean isStrongElementOnRisingSlope = true;
    }
}

