/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.ByteIterator;
import kotlin.Charsets;
import kotlin.io.IoPackage$Console$51e6ca4c;
import kotlin.io.IoPackage$IOStreams$977567d6;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@KotlinSyntheticClass(abiVersion=20, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class IoPackage$IOStreams$977567d6 {
    @NotNull
    public static final ByteIterator iterator(@JetValueParameter(name="$receiver") InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return (ByteIterator)new KObject($receiver){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ InputStream receiver$0;

            static {
                $kotlinClass = Reflection.createKotlinClass(iterator.1.class);
            }

            public boolean hasNext() {
                return this.receiver$0.available() > 0;
            }

            public byte nextByte() {
                return (byte)this.receiver$0.read();
            }
            {
                this.receiver$0 = $receiver;
            }

            public void remove() {
                throw new UnsupportedOperationException("Mutating immutable collection");
            }
        };
    }

    @NotNull
    public static final InputStream buffered(@JetValueParameter(name="$receiver") InputStream $receiver, @JetValueParameter(name="bufferSize") int bufferSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver instanceof BufferedInputStream ? (BufferedInputStream)$receiver : new BufferedInputStream($receiver, bufferSize);
    }

    public static InputStream buffered$default(InputStream inputStream, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = IoPackage$Console$51e6ca4c.defaultBufferSize;
        }
        return IoPackage$IOStreams$977567d6.buffered(inputStream, n);
    }

    @NotNull
    public static final InputStreamReader reader(@JetValueParameter(name="$receiver") InputStream $receiver, @JetValueParameter(name="charset") @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return new InputStreamReader($receiver, charset);
    }

    public static InputStreamReader reader$default(InputStream inputStream, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = Charsets.getUTF_8();
        }
        return IoPackage$IOStreams$977567d6.reader(inputStream, charset);
    }

    @NotNull
    public static final InputStreamReader reader(@JetValueParameter(name="$receiver") InputStream $receiver, @JetValueParameter(name="charset") @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return new InputStreamReader($receiver, charset);
    }

    @NotNull
    public static final InputStreamReader reader(@JetValueParameter(name="$receiver") InputStream $receiver, @JetValueParameter(name="decoder") @NotNull CharsetDecoder decoder) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(decoder, "decoder");
        return new InputStreamReader($receiver, decoder);
    }

    @NotNull
    public static final BufferedOutputStream buffered(@JetValueParameter(name="$receiver") OutputStream $receiver, @JetValueParameter(name="bufferSize") int bufferSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver instanceof BufferedOutputStream ? (BufferedOutputStream)$receiver : new BufferedOutputStream($receiver, bufferSize);
    }

    public static BufferedOutputStream buffered$default(OutputStream outputStream, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = IoPackage$Console$51e6ca4c.defaultBufferSize;
        }
        return IoPackage$IOStreams$977567d6.buffered(outputStream, n);
    }

    @NotNull
    public static final OutputStreamWriter writer(@JetValueParameter(name="$receiver") OutputStream $receiver, @JetValueParameter(name="charset") @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return new OutputStreamWriter($receiver, charset);
    }

    public static OutputStreamWriter writer$default(OutputStream outputStream, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = Charsets.getUTF_8();
        }
        return IoPackage$IOStreams$977567d6.writer(outputStream, charset);
    }

    @NotNull
    public static final OutputStreamWriter writer(@JetValueParameter(name="$receiver") OutputStream $receiver, @JetValueParameter(name="charset") @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return new OutputStreamWriter($receiver, charset);
    }

    @NotNull
    public static final OutputStreamWriter writer(@JetValueParameter(name="$receiver") OutputStream $receiver, @JetValueParameter(name="encoder") @NotNull CharsetEncoder encoder) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(encoder, "encoder");
        return new OutputStreamWriter($receiver, encoder);
    }

    public static final long copyTo(@JetValueParameter(name="$receiver") InputStream $receiver, @JetValueParameter(name="out") @NotNull OutputStream out, @JetValueParameter(name="bufferSize") int bufferSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(out, "out");
        long bytesCopied = 0L;
        byte[] buffer = new byte[bufferSize];
        int bytes = $receiver.read(buffer);
        while (bytes >= 0) {
            out.write(buffer, 0, bytes);
            bytesCopied += (long)bytes;
            bytes = $receiver.read(buffer);
        }
        return bytesCopied;
    }

    public static long copyTo$default(InputStream inputStream, OutputStream outputStream, int n, int n2) {
        if ((n2 & 2) != 0) {
            n = IoPackage$Console$51e6ca4c.defaultBufferSize;
        }
        return IoPackage$IOStreams$977567d6.copyTo(inputStream, outputStream, n);
    }

    @NotNull
    public static final byte[] readBytes(@JetValueParameter(name="$receiver") InputStream $receiver, @JetValueParameter(name="estimatedSize") int estimatedSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(estimatedSize);
        IoPackage$IOStreams$977567d6.copyTo$default($receiver, buffer, 0, 2);
        byte[] byArray = buffer.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "buffer.toByteArray()");
        return byArray;
    }

    public static byte[] readBytes$default(InputStream inputStream, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = IoPackage$Console$51e6ca4c.defaultBufferSize;
        }
        return IoPackage$IOStreams$977567d6.readBytes(inputStream, n);
    }
}

